<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/intervention_systematic/class/intervention_systematic.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/machine/class/machine.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/maintenance/class/Maintenance.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/maintenance_point/class/MaintenancePoint.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';


// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$mid      = GETPOST('mid', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$intervention_systematic = new intervention_systematic($db);

    if (!$error) {
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $intervention_systematic->datec         = $ety.'-'.$etm.'-'.$etd ;
        }
          $intervention_systematic->counter        = trim(GETPOST('counter_'));
          $intervention_systematic->frequency          = trim(GETPOST('frequency_'));
          $intervention_systematic->note            = trim(GETPOST('note_'));
          $intervention_systematic->alert   = trim(GETPOST('alert_'));
          $intervention_systematic->maintenance_point_id        = trim(GETPOST('maintenance_point_id_'));
          $intervention_systematic->machine_id     = (int)$mid;
          $intervention_systematic->maintenance_id  = trim(GETPOST('maintenance_id_'));
          $intervention_systematic->created_by     = $user->id;
            //if(!$intervention_systematic->check_mat($intervention_systematic->mat)){
                    $intervention_systematicID = $intervention_systematic->create();
            
                    // If no SQL error we redirect to the request card
                    if ($intervention_systematicID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php?mid='.$mid);
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$intervention_systematic->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$intervention_systematic->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $intervention_systematic_id = (int) GETPOST('intervention_systematic_id', 'int');

    if (!$intervention_systematic_id || $intervention_systematic_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $intervention_systematic = new intervention_systematic($db);
    $intervention_systematic->fetch($intervention_systematic_id);

   // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $datec = '';
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $datec         = $ety.'-'.$etm.'-'.$etd ;
        }
        $data = array(
          'datec'  =>$datec,
          'counter'           =>trim(GETPOST('counter_')),
          'frequency' =>trim(GETPOST('frequency_')),
          'note'  =>trim(GETPOST('note_')),
          'alert'      =>trim(GETPOST('alert_')),
          'maintenance_point_id' =>trim(GETPOST('maintenance_point_id_')),
          'machine_id' =>(int)$mid,
          'maintenance_id'  =>trim(GETPOST('maintenance_id_')),
          'updated_at'    =>$now
        );

		$getintervention_systematicID = $intervention_systematic->update($intervention_systematic_id, $data);
        
                if ($getintervention_systematicID > 0) {
                    header('Location: ./index.php?id='.$intervention_systematic_id.'&mid='.$mid);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $intervention_systematic_id .'&action=edit&error=SQL_Create&msg='.$intervention_systematic->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new intervention_systematic($db);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php?mid='.$mid);
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$intervention_systematic     = new intervention_systematic($db);
$maintenance     = new Maintenance($db);
$maintenance_point     = new MaintenancePoint($db);
$machine     = new machine($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('intervention_systematic'),'','','','',$morejs,$morecss,0,0);
$machine->fetch($mid);
        $head = material_prepare_head($machine);
        dol_fiche_head($head, 'intervention_systematic', $langs->trans('intervention_systematic'), 0, '');
        $html .= '<table class="border" width="100%">';
        $html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;
if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addintervention_systematic'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?mid='.$mid.'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';


        //Engin 
        /*print '<tr><td>'.$langs->trans("machine").'</td><td>'; 
        $mark_intervention_systematics = $machine->getMats();
        print $form->selectarray('machine_id_', $mark_intervention_systematics,(GETPOST('machine_id_') ? GETPOST('machine_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/

        //catégorie
        print '<tr><td>'.$langs->trans("maintenance_point").'</td><td>'; 
        $cat_intervention_systematics = $maintenance_point->getNames();
        print $form->selectarray('maintenance_point_id_', $cat_intervention_systematics,(GETPOST('maintenance_point_id_') ? GETPOST('maintenance_point_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //Chantier 
        print '<tr><td>'.$langs->trans("maintenance").'</td><td>'; 
        $const_sites = $maintenance->getNames();
        print $form->selectarray('maintenance_id_', $const_sites,(GETPOST('maintenance_id_') ? GETPOST('maintenance_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

       //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //Compteur
        print '<tr><td class="fieldrequired">'.$langs->trans("counter").'</td><td>';
        print '<input type="number" min="0" value="" name="counter_" required="required" />';
        print '</td></tr>';


       //Prix 
        print '<tr><td class="fieldrequired">'.$langs->trans("frequency").'</td><td>';
        print '<input type="number" value="" min="0" name="frequency_" required="required" />';
        print '</td></tr>';

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("note").'</td><td>';
        print '<input type="text" value="" name="note_" required="required" />';
        print '</td></tr>';

        //Heures Travaillés  
        print '<tr><td class="fieldrequired">'.$langs->trans("alert").'</td><td>';
        print '<input type="number" min="0" value="" name="alert_" required="required" />';
        print '</td></tr>';
        

        
        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createintervention_systematic") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $intervention_systematic->fetch($id);

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'intervention_systematics', $langs->trans("intervention_systematic"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'&mid='.$mid.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="intervention_systematic_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';

         //Engin 
       /* print '<tr><td>'.$langs->trans("machine").'</td><td>'; 
        $mark_intervention_systematics = $machine->getMats();
        print $form->selectarray('machine_id_', $mark_intervention_systematics,(GETPOST('machine_id_') ? GETPOST('machine_id_') : $intervention_systematic->machine_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/


        //catégorie
        print '<tr><td>'.$langs->trans("maintenance_point").'</td><td>'; 
        $cat_intervention_systematics = $maintenance_point->getNames();
        print $form->selectarray('maintenance_point_id_', $cat_intervention_systematics,(GETPOST('maintenance_point_id_') ? GETPOST('maintenance_point_id_') : $intervention_systematic->maintenance_point_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

         //Chantier 
        print '<tr><td>'.$langs->trans("maintenance").'</td><td>'; 
        $const_sites =  $maintenance->getNames();
        print $form->selectarray('maintenance_id_', $const_sites,(GETPOST('maintenance_id_') ? GETPOST('maintenance_id_') : $intervention_systematic->maintenance_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" value="'.dol_print_date($intervention_systematic->datec,'day').'" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //Compteur
        print '<tr><td class="fieldrequired">'.$langs->trans("counter").'</td><td>';
        print '<input type="number" min="0" value="'.$intervention_systematic->counter.'" name="counter_" required="required" />';
        print '</td></tr>';


       //Prix 
        print '<tr><td class="fieldrequired">'.$langs->trans("frequency").'</td><td>';
        print '<input type="number" min="0" value="'.$intervention_systematic->frequency.'" name="frequency_" required="required" />';
        print '</td></tr>';

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("note").'</td><td>';
        print '<input type="text" value="'.$intervention_systematic->note.'" name="note_" required="required" />';
        print '</td></tr>';

        //Heures Travaillés  
        print '<tr><td class="fieldrequired">'.$langs->trans("alert").'</td><td>';
        print '<input type="number" min="0" value="'.$intervention_systematic->alert.'" name="alert_" required="required" />';
        print '</td></tr>';



       


                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->marches->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>