<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/location_expenses/class/location_expenses.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/machine/class/machine.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/unitType.class.php';


// Get parameters
$User = new User($db);
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$location_expenses = new location_expenses($db);

    if (!$error) {
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $location_expenses->datec         = $ety.'-'.$etm.'-'.$etd ;
        }
        
        $location_expenses->works_nature            = trim(GETPOST('works_nature_'));
        $location_expenses->counter          = trim(GETPOST('counter_'));
        $location_expenses->fuel_recovery           = trim(GETPOST('fuel_recovery_'));
        $location_expenses->num    = trim(GETPOST('num_'));
        $location_expenses->price = trim(GETPOST('price_'));
        $location_expenses->location_rate  = trim(GETPOST('location_rate_'));
        $location_expenses->location_qty      = trim(GETPOST('location_qty_'));
        $location_expenses->nbrheursengin      = trim(GETPOST('nbrheursengin_'));
        $location_expenses->fuel_id = trim(GETPOST('fuel_id_'));
        $location_expenses->machine_id = trim(GETPOST('machine_id_'));
        $location_expenses->unit_type_id   = trim(GETPOST('unit_type_id_'));
        $location_expenses->tenant_id      = trim(GETPOST('tenant_id_'));
        $location_expenses->const_site_id  = trim(GETPOST('const_site_id_'));
        $location_expenses->created_by     = $user->id;
        //if(!$location_expenses->check_mat($location_expenses->mat)){
        $location_expensesID = $location_expenses->create();
        // If no SQL error we redirect to the request card
        if ($location_expensesID > 0) {
            //header('Location: index.php?id='.$getMarcheID);
            header('Location: index.php');
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: card.php?action=request&error=SQL_Create&msg='.$location_expenses->error);
            exit;
        }
        /* }
        else{
        $msg ='Cette marticule '.$location_expenses->mat.' est deja saisée !';
        header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
        exit;
        }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $location_expenses_id = (int) GETPOST('location_expenses_id', 'int');

    if (!$location_expenses_id || $location_expenses_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $location_expenses = new location_expenses($db);
    $location_expenses->fetch($location_expenses_id);

   // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $datec         = $ety.'-'.$etm.'-'.$etd ;
        }
        $data = array(
          'works_nature'           =>trim(GETPOST('works_nature_')),
          'counter'          =>trim(GETPOST('counter_')),
          'datec'            =>$datec,
          'fuel_recovery'           =>trim(GETPOST('fuel_recovery_')),
          'num'    =>trim(GETPOST('num_')),
          'price' =>trim(GETPOST('price_')),
          'location_rate'  =>trim(GETPOST('location_rate_')),
          'location_qty'      =>trim(GETPOST('location_qty_')),
          'nbrheursengin'      =>trim(GETPOST('nbrheursengin_')),
          'fuel_id' =>trim(GETPOST('fuel_id_')),
          'machine_id' =>trim(GETPOST('machine_id_')),
          'unit_type_id'   =>trim(GETPOST('unit_type_id_')),
          'tenant_id'     =>trim(GETPOST('tenant_id_')),
          'const_site_id'  =>trim(GETPOST('const_site_id_')),
          'updated_at'    =>$now
        );

		$getlocation_expensesID = $location_expenses->update($location_expenses_id, $data);
        
                if ($getlocation_expensesID > 0) {
                    header('Location: ./index.php?id='.$location_expenses_id);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $location_expenses_id .'&action=edit&error=SQL_Create&msg='.$location_expenses->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new location_expenses($db);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php');
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$location_expenses     = new location_expenses($db);
$machine     = new machine($db);
$ConstructionSite     = new ConstructionSite($db);
$unit_type = new unitType($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('location_expenses'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addlocation_expenses'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

         //Numéro
        print '<tr><td class="fieldrequired">'.$langs->trans("num").'</td><td>';
        print '<input type="number" min="0" value="" name="num_" required="required" />';
        print '</td></tr>';

        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("dated").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        // works_nature
        print '<tr><td class="fieldrequired">'.$langs->trans("works_nature").'</td><td>';
        print '<input type="text" value="" name="works_nature_" required="required" />';
        print '</td></tr>';

        //engin
        print '<tr><td>'.$langs->trans("machine").'</td><td>'; 
        $machines = $machine->getMats();
        print $form->selectarray('machine_id_', $machines,(GETPOST('machine_id_') ? GETPOST('machine_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //carburant
        print '<tr><td>'.$langs->trans("unit_type").'</td><td>'; 
        $mark_location_expenses = $unit_type->getNames();
        print $form->selectarray('unit_type_id_', $mark_location_expenses,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //unit type
        print '<tr><td>'.$langs->trans("fuel").'</td><td>'; 
        $unit_types = array(1 => 'fuel 1', 2 => 'fuel 2');
        print $form->selectarray('fuel_id_', $unit_types,(GETPOST('fuel_id_') ? GETPOST('fuel_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //compteur
        print '<tr><td class="fieldrequired">'.$langs->trans("counter").'</td><td>';
        print '<input type="text" value="" name="counter_" required="required" />';
        print '</td></tr>';

        //réservoir carburant
        print '<tr><td class="fieldrequired">'.$langs->trans("fuel_recovery").'</td><td>';
        print '<input type="number" min="0" value="" name="fuel_recovery_" required="required" />';
        print '</td></tr>';



        //Prix 
        print '<tr><td class="fieldrequired">'.$langs->trans("price").'</td><td>';
        print '<input type="number" step="0.01" min="0" value="" name="price_" required="required" />';
        print '</td></tr>';

        //Tarif de Location  
        print '<tr><td class="fieldrequired">'.$langs->trans("location_rate").'</td><td>';
        print '<input type="number" step="0.01" min="0" value="" name="location_rate_" required="required" />';
        print '</td></tr>';

        //Quantité de Location  
        print '<tr><td class="fieldrequired">'.$langs->trans("location_qty").'</td><td>';
        print '<input type="number" min="0" value="" name="location_qty_" required="required" />';
        print '</td></tr>';

        //Nombre d'heures d'engin   
        print '<tr><td class="fieldrequired">'.$langs->trans("Nombre d'heures d'engin ").'</td><td>';
        print '<input type="number" min="0" value="" step="0.1" name="nbrheursengin_"  />';
        print '</td></tr>';

        //locataire 
         print '<tr><td>'.$langs->trans("tenant").'</td><td>'; 
         print $form->select_dolusers(null,'tenant_id_');
         print '</td></tr>';

        //Chantier 
        print '<tr><td>'.$langs->trans("const_site").'</td><td>'; 
        $const_sites = $ConstructionSite->getNames();
        print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createlocation_expenses") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    print_fiche_titre($langs->trans("location_expenses"));
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $location_expenses->fetch($id);

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'location_expenses', $langs->trans("location_expenses"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="location_expenses_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';

                    //N° chassis
                    print '<tr><td class="fieldrequired">'.$langs->trans("num").'</td><td>';
                    print '<input type="number" min="0" value="'.$location_expenses->num.'" name="num_" required="required" />';
                    print '</td></tr>';
                    
                    //date
                    print '<tr><td class="fieldrequired">'.$langs->trans("dated").'</td><td>';
                    print '<input type="text" value="'.dol_print_date($location_expenses->datec,'day').'" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
                    print '</td></tr>';

                    // works_nature
                    print '<tr><td class="fieldrequired">'.$langs->trans("works_nature").'</td><td>';
                    print '<input type="text" value="'.$location_expenses->works_nature.'" name="works_nature_" required="required" />';
                    print '</td></tr>';

                    //engin
                    print '<tr><td>'.$langs->trans("machine").'</td><td>'; 
                    $machines = $machine->getMats();
                    print $form->selectarray('machine_id_', $machines,(GETPOST('machine_id_') ? GETPOST('machine_id_') : $location_expenses->machine_id), 0, 0, 0, 'required="required"');
                    print '</td></tr>';

                    //unit type
                    print '<tr><td>'.$langs->trans("unit_type").'</td><td>'; 
                    $unit_types = $unit_type->getNames();
                    print $form->selectarray('unit_type_id_', $unit_types,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : $location_expenses->unit_type_id), 0, 0, 0, 'required="required"');
                    print '</td></tr>';

                    //carburant
                    print '<tr><td>'.$langs->trans("fuel").'</td><td>'; 
                    $mark_location_expenses = array(1 => 'fuel 1', 2 => 'fuel 2');
                    print $form->selectarray('fuel_id_', $mark_location_expenses,(GETPOST('fuel_id_') ? GETPOST('fuel_id_') : $location_expenses->fuel_id), 0, 0, 0, 'required="required"');
                    print '</td></tr>';

                    //counter
                    print '<tr><td class="fieldrequired">'.$langs->trans("counter").'</td><td>';
                    print '<input type="text" value="'.$location_expenses->counter.'" name="counter_" required="required" />';
                    print '</td></tr>';

                    //année
                    print '<tr><td class="fieldrequired">'.$langs->trans("fuel_recovery").'</td><td>';
                    print '<input type="number" min="0" value="'.$location_expenses->fuel_recovery.'" name="fuel_recovery_" required="required" />';
                    print '</td></tr>';

                   //Prix 
                    print '<tr><td class="fieldrequired">'.$langs->trans("price").'</td><td>';
                    print '<input type="number" step="0.01" min="0" value="'.$location_expenses->price.'" name="price_" required="required" />';
                    print '</td></tr>';

                    //Tarif de Location  
                    print '<tr><td class="fieldrequired">'.$langs->trans("location_rate").'</td><td>';
                    print '<input type="number" step="0.01" min="0" value="'.$location_expenses->location_rate.'" name="location_rate_" required="required" />';
                    print '</td></tr>';

                    //Quantité location   
                    print '<tr><td class="fieldrequired">'.$langs->trans("location_qty").'</td><td>';
                    print '<input type="number"  min="0" value="'.$location_expenses->location_qty.'" name="location_qty_" required="required" />';
                    print '</td></tr>';

                    //Nombre d'heures d'engin   
                    print '<tr><td class="fieldrequired">'.$langs->trans("Nombre d'heures d'engin ").'</td><td>';
                    print '<input type="number" value="'.$location_expenses->nbrheursengin.'" min="0" step="0.1" name="nbrheursengin_" />';
                    print '</td></tr>';

                    //locataire 
                    print '<tr><td>'.$langs->trans("tenant").'</td><td>'; 
                    print $form->select_dolusers($location_expenses->tenant_id,'tenant_id_');
                    print '</td></tr>';

                    //Chantier 
                    print '<tr><td>'.$langs->trans("const_site").'</td><td>'; 
                    $const_sites = $ConstructionSite->getNames();
                    print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : $location_expenses->const_site_id), 0, 0, 0, 'required="required"');
                    print '</td></tr>';



                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->marches->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>