<?php
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class location_expenses extends Commonobject{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

  public $works_nature;
  public $counter;
  public $datec;
  // public $nmbrjourchantier;
  public $fuel_recovery;
  public $num;
  public $price;
  public $location_rate;
  public $location_qty ;
  public $nbrheursengin ;
  public $fuel_id ;
  public $machine_id ;
  public $unit_type_id 	;
  public $tenant_id ;
  public $const_site_id	 ;
  public $created_by ;
  public $created_at ;
  public $updated_at ;
  public $rows = array();

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d');
		return 1;
	}


	public function getHeuresUtilisationEngins($idengin)
	{
		$heurs = 0;
		$sql = 'SELECT *';
		$sql.= ' FROM '. MAIN_DB_PREFIX .'location_expenses';
		$sql.= ' WHERE machine_id = ' . $idengin;

		// die($sql);
		$result = array();
		$this->db->begin();
		$resql = $this->db->query($sql);

		$arrnbresheurs = [];
		if($resql){
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$machine     = new machine($this->db);
				while ($obj = $this->db->fetch_object($resql)) {
					$machine->fetch($obj->machine_id);
					$heurs = $obj->nbrheursengin * $machine->couthoraireengin;
					if (isset($arrnbresheurs[$obj->machine_id]))
						$arrnbresheurs[$obj->machine_id]	= $arrnbresheurs[$obj->machine_id] + $heurs;
					else
						$arrnbresheurs[$obj->machine_id]	= $heurs;
				}
			}
			$this->db->free($resql);
		}
		return $arrnbresheurs;
	}
	public function getSommeLastCoutDepens($id,$datec)
	{
		$sum = 0;
		$sql = 'SELECT SUM(price) as sum ';
		$sql.= ' FROM '. MAIN_DB_PREFIX .'location_expenses';
		$sql.= ' WHERE datec <= "'. $datec.'" AND rowid != '.$id;
		// echo $datec."<br>";
		// echo $sql."<br>";
		// die();
		$result = array();
		$this->db->begin();
		$resql = $this->db->query($sql);
		if($resql){
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				$sum	= $obj->sum;
			}

			$this->db->free($resql);
		}
		return $sum;
	}

	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : $this->num;
        $id  	= ($id  ?: $this->id);
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/material/location_expenses/index.php?id='. $id .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        if ($setRef != "") {
        	$result = $link."<div class='icon-empty_folder mainvmenu'></div>  ".$setRef.$linkend;
        }else{
        	$result = "-";
        }
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
	  $this->works_nature = $this->works_nature ? $this->db->escape($this->works_nature): null;
	  $this->counter= $this->counter ? $this->db->escape($this->counter): null;
	  $this->datec = $this->datec ? $this->db->escape($this->datec): null;
	  // $this->nmbrjourchantier = $this->nmbrjourchantier ? $this->db->escape($this->nmbrjourchantier): null;
	  $this->fuel_recovery = $this->fuel_recovery ? $this->db->escape($this->fuel_recovery): null;
	  $this->num = $this->num ? $this->db->escape($this->num): null;
	  $this->price = $this->price ? $this->db->escape($this->price): null;
	  $this->location_rate = $this->location_rate ? $this->db->escape($this->location_rate): null;
	  $this->location_qty = $this->location_qty ? $this->db->escape($this->location_qty): null;
	  $this->nbrheursengin = $this->nbrheursengin ? $this->db->escape($this->nbrheursengin): null;
	  $this->fuel_id = $this->fuel_id ? $this->db->escape($this->fuel_id): null;
	  $this->machine_id = $this->machine_id ? $this->db->escape($this->machine_id): null;
	  $this->unit_type_id = $this->unit_type_id ? $this->db->escape($this->unit_type_id): null;
	  $this->tenant_id = $this->tenant_id ? $this->db->escape($this->tenant_id): null;
	  $this->const_site_id	= $this->const_site_id ? $this->db->escape($this->const_site_id): null;
	  $this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
	  $this->created_at = $this->now;
	// Insert request
	$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'location_expenses' . ' (works_nature,counter,datec,';
	$sql .= 'fuel_recovery,num,price,location_rate,location_qty,nbrheursengin,fuel_id,';
	$sql .= 'machine_id,unit_type_id,tenant_id,const_site_id,created_by,created_at,updated_at) ';
	$sql .= 'VALUES ("'.$this->works_nature.'", "'.$this->counter.'", "'.$this->datec.'",';
	$sql .=	$this->fuel_recovery.', "'.$this->num.'", '.$this->price.', '.$this->location_rate.',';
	$sql .=	$this->location_qty.','.$this->nbrheursengin.', '.$this->fuel_id.', '.$this->machine_id.',';
	$sql .=	$this->unit_type_id.', '.$this->tenant_id.', '.$this->const_site_id.', '.$this->created_by.',"';
	$sql .=	$this->created_at.'",NULL)';
	// die($sql);
	$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error location_expenses ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			return 1;
			//return $this->getLasInsrtedId();
		}
	}

/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'location_expenses';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->id             = $obj->rowid;
			  $this->works_nature 			= $obj->works_nature ;
			  $this->counter 			= $obj->counter ;
			  $this->datec 	= $this->db->jdate($obj->datec) ;
			  // $this->nmbrjourchantier 	= $obj->nmbrjourchantier ;
			  $this->fuel_recovery 			= $obj->fuel_recovery ;
			  $this->num 	= $obj->num ;
			  $this->price = $obj->price ;
			  $this->location_rate 	= $obj->location_rate ;
			  $this->location_qty 		= $obj->location_qty ;
			  $this->nbrheursengin 		= $obj->nbrheursengin ;
			  $this->fuel_id = $obj->fuel_id ;
			  $this->machine_id = $obj->machine_id ;
			  $this->unit_type_id 	= $obj->unit_type_id ;
			  $this->tenant_id 		= $obj->tenant_id ;
			  $this->const_site_id	= $obj->const_site_id ;
			  $this->created_by 	= $obj->created_by ;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'location_expenses';

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
					$line->id 			 = $obj->rowid;
					$line->works_nature 			= $obj->works_nature ;
				 $line->counter 			= $obj->counter ;
				  $line->datec 	= $this->db->jdate($obj->datec) ;
				  // $line->nmbrjourchantier 	= $obj->nmbrjourchantier ;
				  $line->fuel_recovery 			= $obj->fuel_recovery ;
				  $line->num 	= $obj->num ;
				  $line->price = $obj->price ;
				  $line->location_rate 	= $obj->location_rate ;
				  $line->location_qty 		= $obj->location_qty ;
				  $line->nbrheursengin 		= $obj->nbrheursengin ;
				  $line->fuel_id = $obj->fuel_id ;
				  $line->machine_id = $obj->machine_id ;
				  $line->unit_type_id 	= $obj->unit_type_id ;
				  $line->tenant_id 		= $obj->tenant_id ;
				  $line->const_site_id	= $obj->const_site_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
					$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 * Updatec object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Updatec request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'location_expenses' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
			$now = new \DateTime("now");
			$now 		 = $now->format('Y-m-d');
			$sql .= '`updated_at` = '. $now ;

		//$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'location_expenses' .' WHERE rowid = ' . $this->id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	public function getCamions()
    {
    	$this->fetchAll('','','','',' AND type = 1');
    	$camions = array();

    	if (count($this->rows))
    	foreach ($this->rows as $key => $line) {
			$camions[$line->id] = $line->mat;    		
    	}

    	return $camions;
    }

    public function getMats()
    {
    	$this->fetchAll();
    	$camions = array();

    	if (count($this->rows))
    	foreach ($this->rows as $key => $line) {
			$camions[$line->id] = $line->num;    		
    	}

    	return $camions;
    }

    public function check_mat($mat)
    {
    	$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'location_expenses WHERE mat ="'.$mat.'"';
    	$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			if($num > 0)
				return true;
			$this->db->free($resql);
    	}

    	return false;
    }

    public function getMat($id)
    {
    	$sql = 'SELECT num FROM ' . MAIN_DB_PREFIX . 'location_expenses WHERE rowid='.$id;
    	$resql = $this->db->query($sql);
    	$mat = '';
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$mat = $obj->num;
			}
			$this->db->free($resql);
    	}

    	return $mat;
    }

    public function getStatData()
    {
    	global $langs;
    	$this->fetchAll();
    	$countAmount = 0;

    	foreach ($this->rows as $key => $obj)
    		$countAmount += ($obj->location_rate*$obj->location_qty);

    	$object 		= new stdClass();
    	$object->number = count($this->rows);
    	$object->cost 	= $countAmount;
    	$object->label 	= $langs->trans('location_expenses');
    	$object->url 	= DOL_URL_ROOT.'/btp/material/location_expenses/index.php';

    	return $object;
    }

	/**
     * Load indicators for dashboard (this->nbtodo and this->nbtodolate)
     *
     * @param	User	$user   Objet user
     * @return WorkboardResponse|int <0 if KO, WorkboardResponse if OK
     */
    public function load_board()
    {
        global $conf, $user, $langs;

		require_once DOL_DOCUMENT_ROOT . '/btp/material/fuel/class/fuel.class.php';
		require_once DOL_DOCUMENT_ROOT . '/btp/material/lubricant/class/lubricant.class.php';
		require_once DOL_DOCUMENT_ROOT . '/btp/material/location/class/location.class.php';
		require_once DOL_DOCUMENT_ROOT . '/btp/material/location_recipe/class/location_recipe.class.php';
		require_once DOL_DOCUMENT_ROOT . '/btp/material/receptions/class/receptions.class.php';

		$fuel 		= new fuel($this->db);
		$lubricant 	= new lubricant($this->db);
		$location 	= new location($this->db);
		$locationRecipe = new location_recipe($this->db);
		$receptions = new receptions($this->db);

        return array($this->getStatData(), $fuel->getStatData(), $lubricant->getStatData(),
        	$location->getStatData(), $locationRecipe->getStatData(), 
        	$receptions->getStatData());
    }

}
?>