<?php
/* Copyright (C) 2016	Souieh Laghdaf	<laghdaf.souieh@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       /material/oc_cats_items/index.php
 * \ingroup    list
 * \brief      List of location expensess
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/oc_cats_items/class/oc_cats_items.class.php';
//require_once DOL_DOCUMENT_ROOT.'/btp/material/oc_cats/class/oc_cats.class.php';


$form 		= new Form($db);
$oc_cats_items     = new oc_cats_items($db);
//$oc_cats = new oc_cats($db);

$var = false;
$filter = '';
$refs_oc_cats_itemss = array(1 => $langs->trans('track'), 2 => $langs->trans('other'));
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$search_ref      		= GETPOST('search_ref');
$search_designation     = GETPOST('search_designation');
$search_oc_cat    		= GETPOST('search_oc_cat');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_ref      		= '';
$search_designation		= '';
$search_oc_cat    		= '';
}
$filter .= (!empty($search_ref) && $search_ref != -1) ? " AND ref = '". $db->escape($search_ref)."'\n" : "";
$filter .= (!empty($search_designation) && $search_designation != -1) ? " AND designation = '".$db->escape($search_designation)."'\n" : "";
//$filter .= (!empty($search_oc_cat) && $search_oc_cat != -1) ? " AND oc_cat_id = '".$db->escape($search_oc_cat)."'\n" : "";


$getoc_cats_itemss = $oc_cats_items->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);
if (!empty($getoc_cats_itemss) && $action == "xsl" ) {
$filename="liste_demandes_categories.xls";
      require_once DOL_DOCUMENT_ROOT.'/btp/material/oc_cats_items/tpl/oc_cats_items_exl.php';
 die();
 
}
// Si erreur SQL
if ($getoc_cats_itemss == '-1') {
    print_fiche_titre($langs->trans('ListOfoc_cats_items'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$oc_cats_items->error);
    exit();
}
if ($id > 0) {
	$oc_cats_items->fetch($id);
	llxHeader('', $langs->trans('oc_cats_items'));
	print_fiche_titre($langs->trans("oc_cats_items"));


	print '<table class="border" width="100%">';
	// ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ref").'</td>';
	print '<td colspan="2">'. $oc_cats_items->ref .'</td></tr>';
	// designation
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("designation").'</td>';
	print '<td colspan="2">'. $oc_cats_items->designation .'</td></tr>';
	// oc_cats
	/*print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("oc_cats").'</td>';
	$oc_cats->fetch($oc_cats_items->oc_cat_id);
	print '<td colspan="2">'. $oc_cats->getNomUrl('1') .'</td></tr>';*/
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'" class="butAction">'.$langs->trans('Delete').'</a>';
	print '</div>';

	 if ($action == 'delete') {
                   print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {

 // Both test are required to be compatible with all browsers

llxHeader('', $langs->trans('oc_cats_items'));
print_fiche_titre($langs->trans("ListOfoc_cats_items"));


	dol_fiche_head('', 'oc_cats_itemss', $langs->trans("Listoc_cats_items"), 1, '');
print '<div style="float: right; margin-bottom: 4px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addoc_cats_items').'</a>';
		print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_ref" value="'. $search_ref .'" type="hidden" />';
print '<input name="search_designation" value="'. $search_designation .'" type="hidden" />';
print '<input name="search_oc_cat" value="'. $search_oc_cat .'" type="hidden" />';

print '<input name="action" value="xsl" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("ref"), $_SERVER["PHP_SELF"], 'ref', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("designation"),$_SERVER["PHP_SELF"], "designation", '', '', 'align="center"', $sortfield, $sortorder);
	//print_liste_field_titre($langs->trans("oc_cats"), $_SERVER["PHP_SELF"], 'oc_cat_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// matricule
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="number" min="0" size="14" name="search_ref" value="'.$search_ref.'">';
	print '</td>';

	// ref
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" type="text" size="30" name="search_designation" value="'.$search_designation.'">';
	print '</td>';

	// ref
	/*print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_oc_cat', $oc_cats->getNames(), $search_oc_cat, 1, 0, 0, 'required="required"');
	print '</td>';
*/
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($oc_cats_items->rows)) {
		//$createdBy = new User($db);
		foreach($oc_cats_items->rows as $obj) {
			  $designation 				= $obj->designation ;
			  $ref 			    = $obj->ref ;
			  //$oc_cats->fetch($obj->oc_cat_id) ;
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $oc_cats_items->getNomUrl(1,  $obj->id, $ref);
			print '</td>';
			 
			print '<td align="center">'.$designation.'</td>';
			//print '<td align="center">'. $oc_cats->getNomUrl('1')	 .'</td>';
			print '<td align="center"></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


}

llxFooter();

$db->close();


?>