<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/receptions/class/receptions.class.php';
include_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/machine.lib.php';


$form 		= new Form($db);
$receptions   = new receptions($db);
$societe     = new Societe($db);
$ConstructionSite   = new ConstructionSite($db);

$var = false;
$filter = '';
$categories =  array('1' => 'categorie 1', '2'=> 'categorie 2' );
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$search_ref      		= GETPOST('search_ref');
$search_datec      		= "";
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}

$search_tva    		= GETPOST('search_tva');
$search_cat    		= GETPOST('search_cat');
$search_purchase_order    		= GETPOST('search_purchase_order');
$search_delivery_order    		= GETPOST('search_delivery_order');
$search_company    		= GETPOST('search_company');
$search_supplier    		= GETPOST('search_supplier');
$search_const_site    		= GETPOST('search_const_site');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_ref      		= '';
$search_datec      		= '';
$search_tva    		= '';
$search_cat    		= '';
$search_purchase_order    		= '';
$search_delivery_order    		= '';
$search_company    		= '';
$search_supplier    		= '';
$search_const_site    		= '';
}
$filter .= (!empty($search_ref) && $search_ref != -1) ? " AND ref = '". $db->escape($search_ref)."'\n" : "";
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datec = '". $db->escape($search_datec)."'\n" : "";
$filter .= ( $search_tva != '') ? " AND tva = ".$db->escape($search_tva):"";
$filter .= (!empty($search_cat) && $search_cat != -1) ? " AND cat_id = ".$db->escape($search_cat):"";
$filter .= (!empty($search_purchase_order) && $search_purchase_order != -1) ? " AND purchase_order = ".$db->escape($search_purchase_order):"";
$filter .= (!empty($search_delivery_order) && $search_delivery_order != -1) ? " AND delivery_order = ".$db->escape($search_delivery_order):"";
$filter .= (!empty($search_company) && $search_company != -1) ? " AND company_id = ".$db->escape($search_company):"";
$filter .= (!empty($search_supplier) && $search_supplier != -1) ? " AND supplier_id = ".$db->escape($search_supplier):"";
$filter .= (!empty($search_const_site) && $search_const_site != -1) ? " AND const_site_id = ".$db->escape($search_const_site):"";
$filter .= (!empty($search_transp) && $search_transp != -1) ? " AND e.transp = '".$db->escape($search_transp)."'\n" : "";


$getreceptionss = $receptions->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);
if (!empty($getreceptionss) && $action == "xsl" ) {
$filename="liste_receptions.xls";
      require_once DOL_DOCUMENT_ROOT.'/btp/material/receptions/tpl/receptions_exl.php';
 die();
 
}
// Si erreur SQL
if ($getreceptionss == '-1') {
    print_fiche_titre($langs->trans('ListOfreceptions'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$receptions->error);
    exit();
}
if ($id > 0) {
	$receptions->fetch($id);
	llxHeader('', $langs->trans('receptions'));
	print_fiche_titre($langs->trans("receptions"));

	$reception  = receptions_prepare_head($receptions);
	dol_fiche_head($reception, 'receptions', $langs->trans("receptions"), 0, '');

	print '<table class="border" width="100%">';
	// chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ref").'</td>';
	print '<td colspan="2">'. $receptions->ref .'</td></tr>';
	// tva
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("tva").'</td>';
	print '<td colspan="2">'. $receptions->tva .'</td></tr>';
	// note
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("note").'</td>';
	print '<td colspan="2">'. $receptions->note .'</td></tr>';
	// engin
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("cat").'</td>';
	print '<td colspan="2">'. $categories[$receptions->cat_id].'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($receptions->datec,'day') .'</td></tr>';
	// chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("purchase_order").'</td>';
	print '<td colspan="2">'. $receptions->purchase_order .'</td></tr>';
	// chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("delivery_order").'</td>';
	print '<td colspan="2">'. $receptions->delivery_order .'</td></tr>';
	//product
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("company").'</td>';
	$societe->fetch($receptions->company_id);
	print '<td colspan="2">'. $societe->getNomUrl('1') .'</td></tr>';
	//travaux
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("supplier").'</td>';
	$societe->fetch($receptions->supplier_id);
	print '<td colspan="2">'. $societe->getNomUrl('1') .'</td></tr>';
	// chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ConstructionSite").'</td>';
	$ConstructionSite->fetch($receptions->const_site_id);
	print '<td colspan="2">'. $ConstructionSite->getNomUrl(1,$ConstructionSite->id,$ConstructionSite->name,$ConstructionSite->market_id) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'" class="butAction">'.$langs->trans('Delete').'</a>';
	print '</div>';

	if ($action == 'delete') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }

}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('receptions'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("ListOfreceptions"));


	dol_fiche_head('', 'receptions', $langs->trans("ListOfreceptions"), 1, '');
print '<div style="float: right; margin-bottom: 4px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addreceptions').'</a>';
		print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_ref" value="'. $search_ref .'" type="hidden" />';
print '<input name="search_datec" value="'. $search_datec .'" type="hidden" />';
print '<input name="search_tva" value="'. $search_tva .'" type="hidden" />';
print '<input name="search_cat" value="'. $search_cat .'" type="hidden" />';
print '<input name="search_purchase_order" value="'. $search_purchase_order .'" type="hidden" />';
print '<input name="search_delivery_order" value="'. $search_delivery_order .'" type="hidden" />';
print '<input name="search_company" value="'. $search_company .'" type="hidden" />';
print '<input name="search_supplier" value="'. $search_supplier .'" type="hidden" />';
print '<input name="search_const_site" value="'. $search_const_site .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("ref"), $_SERVER["PHP_SELF"], 'ref', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("datec"), $_SERVER["PHP_SELF"], 'datec', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("tva"),$_SERVER["PHP_SELF"],"tva", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("note"),$_SERVER["PHP_SELF"],"note", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("cat"),$_SERVER["PHP_SELF"],"cat_id", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("purchase_order"), $_SERVER["PHP_SELF"], 'purchase_order', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("delivery_order"), $_SERVER["PHP_SELF"], 'delivery_order', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("company"), $_SERVER["PHP_SELF"], 'company_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("supplier"), $_SERVER["PHP_SELF"], 'supplier_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("ConstructionSite"), $_SERVER["PHP_SELF"], 'const_site_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// matricule
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="10" name="search_ref" value="'.$search_ref.'">';
	print '</td>';
	//date
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec"  readonly="readonly" /> ';
    print '</td>';
    // tva
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0"  name="search_tva" value="'.$search_tva.'">';
	print '</td>';
	// note
	print '<td class="liste_titre" colspan="1" align="center">';
	print '</td>';
	// type
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_cat', $categories, $search_cat, 1, 0, 0, 'required="required"');
	print '</td>';
// tva
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0"  name="search_purchase_order" value="'.$search_purchase_order.'">';
	print '</td>';
	// tva
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" style="width: 85px" type="number" step="0.01" min="0"  name="search_delivery_order" value="'.$search_delivery_order.'">';
	print '</td>';
	// tva
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->select_thirdparty($search_company,'search_company');
    print '</td>';
	
	print '<td class="liste_titre" colspan="1" align="center">';
	print  $form->select_thirdparty($search_supplier,"search_supplier",'s.fournisseur=1');
        print '</td>';
	
// type
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_const_site', $ConstructionSite->getNames(), $search_const_site, 1, 0, 0, 'required="required"');
	print '</td>';
	// Date création
	// print '<td class="liste_titre" colspan="1" align="center">';
	// print '</td>';
	

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($receptions->rows)) {
		//$createdBy = new User($db);
		foreach($receptions->rows as $obj) {
			  $tva 				= $obj->tva ;
			  $datec 			= dol_print_date($obj->datec,'day') ;
			  $note 		= $obj->note ;
			  $cat_id 		= $categories[$obj->cat_id] ;
			  $ConstructionSite->fetch($obj->const_site_id) ;
			  $ref         		= $obj->ref ;
			  $purchase_order         	= $obj->purchase_order ;
			  $delivery_order         	= $obj->delivery_order ;
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $receptions->getNomUrl(1,  $obj->id, $ref);
			print '</td>';
			print '<td align="center">'. $datec .'</td>';
			print '<td align="center">'. $tva .'</td>';
			print '<td align="center">'. $note .'</td>';
			print '<td align="center">'. $cat_id .'</td>';
			print '<td align="center">'. $purchase_order .'</td>';
			print '<td align="center">'. $delivery_order .'</td>';
			$societe->fetch($obj->company_id) ;
			print '<td align="center">'. $societe->getNomUrl('1') .'</td>';
			$societe->fetch($obj->supplier_id);
			print '<td align="center">'. $societe->getNomUrl('1').'</td>';
			print '<td align="center">'. $ConstructionSite->getNomUrl(1,$ConstructionSite->id,$ConstructionSite->name,$ConstructionSite->market_id).'</td>';
			print '<td align="center"></td>';
			
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';



}

llxFooter();

$db->close();


?>