<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/work_advances_noslip/class/work_advances_noslip.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/constraction_site/class/constraction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/unitType.class.php';
include_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';


// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$work_advances_noslip = new work_advances_noslip($db);

    if (!$error) {
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $work_advances_noslip->datec         = $ety.'-'.$etm.'-'.$etd ;
        }
         $work_advances_noslip->works_nature            = trim(GETPOST('works_nature_'));
          $work_advances_noslip->works_place          = trim(GETPOST('works_place_'));
          $work_advances_noslip->qty           = trim(GETPOST('qty_'));
          $work_advances_noslip->salaries_num  = trim(GETPOST('salaries_num_'));
          $work_advances_noslip->amount      = trim(GETPOST('amount_'));
          $work_advances_noslip->company_id = trim(GETPOST('company_id_'));
          $work_advances_noslip->supply_id = trim(GETPOST('supply_id_'));
          $work_advances_noslip->unit_type_id   = trim(GETPOST('unit_type_id_'));
          $work_advances_noslip->const_site_id  = trim(GETPOST('const_site_id_'));
          $work_advances_noslip->created_by     = $user->id;
            //if(!$work_advances_noslip->check_mat($work_advances_noslip->mat)){
                    $work_advances_noslipID = $work_advances_noslip->create();
            
                    // If no SQL error we redirect to the request card
                    if ($work_advances_noslipID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php');
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$work_advances_noslip->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$work_advances_noslip->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $work_advances_noslip_id = (int) GETPOST('work_advances_noslip_id', 'int');

    if (!$work_advances_noslip_id || $work_advances_noslip_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $work_advances_noslip = new work_advances_noslip($db);
    $work_advances_noslip->fetch($work_advances_noslip_id);

   // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $datec         = $ety.'-'.$etm.'-'.$etd ;
        }
        $data = array(
          'works_nature'           =>trim(GETPOST('works_nature_')),
          'works_place'          =>trim(GETPOST('works_place_')),
          'datec'            =>$datec,
          'qty'           =>trim(GETPOST('qty_')),
          'salaries_num'  =>trim(GETPOST('salaries_num_')),
          'amount'      =>trim(GETPOST('amount_')),
          'company_id' =>trim(GETPOST('company_id_')),
          'supply_id' =>trim(GETPOST('supply_id_')),
          'unit_type_id'   =>trim(GETPOST('unit_type_id_')),
          'const_site_id'  =>trim(GETPOST('const_site_id_')),
          'updated_at'    =>$now
        );

		$getwork_advances_noslipID = $work_advances_noslip->update($work_advances_noslip_id, $data);
        
                if ($getwork_advances_noslipID > 0) {
                    header('Location: ./index.php?id='.$work_advances_noslip_id);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $work_advances_noslip_id .'&action=edit&error=SQL_Create&msg='.$work_advances_noslip->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new work_advances_noslip($db);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php');
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new FormChild($db);
$work_advances_noslip     = new work_advances_noslip($db);
$constraction_site     = new constraction_site($db);
$unit_type = new unitType($db);
$produit   = new product($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('work_advances_noslip'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addwork_advances_noslip'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';


        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        // works_nature
        print '<tr><td class="fieldrequired">'.$langs->trans("works_nature").'</td><td>';
        print '<input type="text" value="" name="works_nature_" required="required" />';
        print '</td></tr>';

        //fourniture
        print '<tr><td>'.$langs->trans("supply").'</td><td>'; 
        print $form->select_produits_list(null,'supply_id_', 0, 30, 0, '', 0, 2);
        print '</td></tr>';

        //carburant
        print '<tr><td>'.$langs->trans("unit_type").'</td><td>'; 
        $mark_work_advances_noslip = $unit_type->getNames();
        print $form->selectarray('unit_type_id_', $mark_work_advances_noslip,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //societe
        print '<tr><td>'.$langs->trans("company").'</td><td>'; 
        $unit_types = array(1 => 'societe 1', 2 => 'societe 2');
        print $form->selectarray('company_id_', $unit_types,(GETPOST('company_id_') ? GETPOST('company_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //compteur
        print '<tr><td class="fieldrequired">'.$langs->trans("works_place").'</td><td>';
        print '<input type="text" value="" name="works_place_" required="required" />';
        print '</td></tr>';

        //réservoir carburant
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="0" value="" name="qty_" required="required" />';
        print '</td></tr>';


        //Tarif de Location  
        print '<tr><td class="fieldrequired">'.$langs->trans("salaries_num").'</td><td>';
        print '<input type="number" min="0" value="" name="salaries_num_" required="required" />';
        print '</td></tr>';

        //Quantité de Location  
        print '<tr><td class="fieldrequired">'.$langs->trans("amount").'</td><td>';
        print '<input type="number" min="0" step="0.01" value="" name="amount_" required="required" />';
        print '</td></tr>';


        //Chantier 
        print '<tr><td>'.$langs->trans("const_site").'</td><td>'; 
        $const_sites = $constraction_site->getNames();
        print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Creatework_advances_noslip") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $work_advances_noslip->fetch($id);

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {
                if ($action == 'delete') {
                    $work_advances_noslip->fetch($id);
     print_fiche_titre($langs->trans("work_advances_noslip"));


    print '<table class="border" width="100%">';
    // works_place
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("works_place").'</td>';
    print '<td colspan="2">'. $work_advances_noslip->works_place .'</td></tr>';
    // datec
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
    print '<td colspan="2">'. dol_print_date($work_advances_noslip->datec,'day') .'</td></tr>';
    // matricule
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("works_nature").'</td>';
    print '<td colspan="2">'. $work_advances_noslip->works_nature .'</td></tr>';
    // année
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
    print '<td colspan="2">'. $work_advances_noslip->qty .'</td></tr>';
   // unit_type
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("unit_type").'</td>';
    $unit_type->fetch($work_advances_noslip->unit_type_id);
    print '<td colspan="2">'. $unit_type->getNomUrl('1') .'</td></tr>';
    // Tarif d'immobilisation 
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("salaries_num").'</td>';
    print '<td colspan="2">'. $work_advances_noslip->salaries_num .'</td></tr>';
    // Tarif de Location
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("amount").'</td>';
    print '<td colspan="2">'. $work_advances_noslip->amount .'</td></tr>';
    // Engin
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("supply").'</td>';
    $produit->fetch($work_advances_noslip->supply_id);
    print '<td colspan="2">'. $produit->getNomUrl('1').'</td></tr>';
    //chantier
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("constraction_site").'</td>';
    $constraction_site->fetch($work_advances_noslip->const_site_id);
    print '<td colspan="2">'. $constraction_site->getNomUrl('1') .'</td></tr>';
    
    
    print '</table>';
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDeleteMarket"),$langs->trans("ConfirmDeleteMarket"),"confirm_delete", '', 0, 1);
                }

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'work_advances_noslip', $langs->trans("work_advances_noslip"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="work_advances_noslip_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';

                   // works_nature
        print '<tr><td class="fieldrequired">'.$langs->trans("works_nature").'</td><td>';
        print '<input type="text" value="'.$work_advances_noslip->works_nature.'" name="works_nature_" required="required" />';
        print '</td></tr>';

        //engin
        print '<tr><td>'.$langs->trans("supply").'</td><td>'; 
        print $form->select_produits_list($work_advances_noslip->supply_id,'supply_id_', 0, 30, 0, '', 0, 2);
        print '</td></tr>';

        //carburant
        print '<tr><td>'.$langs->trans("company").'</td><td>'; 
        $mark_work_advances_noslip = array(1 => 'fuel 1', 2 => 'fuel 2');
        print $form->selectarray('company_id_', $mark_work_advances_noslip,(GETPOST('company_id_') ? GETPOST('company_id_') : $work_advances_noslip->company_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //unit type
        print '<tr><td>'.$langs->trans("unit_type").'</td><td>'; 
        $unit_types = $unit_type->getNames();
        print $form->selectarray('unit_type_id_', $unit_types,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : $work_advances_noslip->unit_type_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';


        //works_place
        print '<tr><td class="fieldrequired">'.$langs->trans("works_place").'</td><td>';
        print '<input type="text" value="'.$work_advances_noslip->works_place.'" name="works_place_" required="required" />';
        print '</td></tr>';

        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" value="'.dol_print_date($work_advances_noslip->datec,'day').'" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //année
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="0" value="'.$work_advances_noslip->qty.'" name="qty_" required="required" />';
        print '</td></tr>';


        //Tarif de Location  
        print '<tr><td class="fieldrequired">'.$langs->trans("salaries_num").'</td><td>';
        print '<input type="number" min="0" value="'.$work_advances_noslip->salaries_num.'" name="salaries_num_" required="required" />';
        print '</td></tr>';

        //Quantité location   
        print '<tr><td class="fieldrequired">'.$langs->trans("amount").'</td><td>';
        print '<input type="number" min="0" step="0.01" value="'.$work_advances_noslip->amount.'" name="amount_" required="required" />';
        print '</td></tr>';

        //Chantier 
        print '<tr><td>'.$langs->trans("const_site").'</td><td>'; 
        $const_sites = $constraction_site->getNames();
        print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : $work_advances_noslip->const_site_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';



                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->marches->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>