<?php
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class list_avancement_travaux extends Commonobject{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */

	public $errors = array();
	public $rowid;
	public $label;

	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		return 1;
	}

	public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/nc_under_modules/avancement_travaux/card.php?id='. $id .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = 'elemt@btp';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{


		$sql = "INSERT INTO " . MAIN_DB_PREFIX . "list_avancement_travaux ( ";
		$sql .= "label";
		$sql .= ") VALUES ( ";
		$sql .= " '".$this->label."' ";
		$sql .= ")";

		// $this->db->begin();
		$resql = $this->db->query($sql);
		//echo $sql."<br>";
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error list_avancement_travaux ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			die();
			return -1;
		} else {

			$sql = "SELECT MAX(rowid) as 'id_parent' FROM ";
			$sql .= MAIN_DB_PREFIX . "list_avancement_travaux";

			$resql = $this->db->query($sql);
			$id_parent ;

			if ($resql) {
				while ($obj = $this->db->fetch_object($resql)) {
						$id_parent = $obj->id_parent;
				}
				$this->db->free($resql);
				return $id_parent;
			}else
				return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'list_avancement_travaux WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			= $this->db->fetch_object($resql);
				$this->rowid 	= $obj->rowid;
				$this->label 	= $obj->label;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX . "list_avancement_travaux";

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		//echo $sql;
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->rowid 	= $obj->rowid;
				$line->label 	= $obj->label;
				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'list_avancement_travaux' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		//echo $sql."<br>";

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'list_avancement_travaux' .' WHERE rowid = ' . $this->rowid;
		//echo "<br>".$sql;
		//echo $sql."<br>";
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {

			$sql = 'DELETE FROM ' . MAIN_DB_PREFIX . 'avancement_travaux' .' WHERE id_list = ' . $this->rowid;
			//echo "<br>".$sql;
			$resql 	= $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();

				$this->errors[] = 'Error ' . $this->db->lasterror();
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
		//echo $sql."<br>";
	}

	public function get_nbr_heur($id_list=0)
	{
		$sql = "SELECT sum(`nbr_heur`) as 'nbr_heur' FROM ";
		$sql .= MAIN_DB_PREFIX . "avancement_travaux WHERE `id_list` = ".$id_list;

		$resql = $this->db->query($sql);
		$nbr_heur = array();

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$nbr_heur = $obj->nbr_heur;
			}
			$this->db->free($resql);
			return $nbr_heur;
		}
	}

	public function get_part_date($date_="",$id_list=0)
	{
		$sql = "SELECT ".$date_."(`date_`) as 'date_' FROM ";
		$sql .= MAIN_DB_PREFIX . "avancement_travaux WHERE `id_list` = ".$id_list;

		$resql = $this->db->query($sql);
		$nbr_heur = array();

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$nbr_heur = $obj->date_;
			}
			$this->db->free($resql);
			return $nbr_heur;
		}
	}

	public function get__date($dt = 'year' ,$filter = '')
	{
		$sql = "SELECT distinct ".$dt."(`date_`) as 'part' FROM ";
		$sql .= MAIN_DB_PREFIX . "avancement_travaux";

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}

		$resql = $this->db->query($sql);
		$dates = array();

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$dates[ $obj->part ] = $obj->part;
			}
			$this->db->free($resql);
			return $dates;
		}
	}

}

class avancement_travaux extends Commonobject{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */

	public $errors = array();
	public $rowid;
	public $date_;
	public $engin;
	public $nbr_heur;
	public $rendement_u;
	public $rendement_ml;
	public $rendement_m2;
	public $rendement_m3;
	public $nature_travaux;
	public $observations;
	public $id_list;

	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->date_ 	 = new DateTime("now");
		$this->date_ 	 = $this->date_->format('Y-m-d');
		return 1;
	}

	public function getNomUrl($withpicto = 0, $id = null,$list_id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/nc_under_modules/avancement_travaux/card_2.php?id='. $id .'&id_list='. $list_id .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = 'elemt@btp';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{


		$sql = "INSERT INTO " . MAIN_DB_PREFIX . "avancement_travaux ( ";

		$sql .= "date_";
		$sql .= ",engin";
		$sql .= ",nbr_heur";
		$sql .= ",rendement_u";
		$sql .= ",rendement_ml";
		$sql .= ",rendement_m2";
		$sql .= ",rendement_m3";
		$sql .= ",nature_travaux";
		$sql .= ",observations";
		$sql .= ",id_list";

		$sql .= ") VALUES ( ";
		$sql .= " '".$this->date_."' ";
		$sql .= " ,'".$this->engin."'";
		$sql .= " , ".$this->nbr_heur." ";
		$sql .= " , ".$this->rendement_u." ";
		$sql .= " , ".$this->rendement_ml." ";
		$sql .= " , ".$this->rendement_m2." ";
		$sql .= " , ".$this->rendement_m3." ";
		$sql .= " ,'".$this->nature_travaux."' ";
		$sql .= " ,'".$this->observations."' ";
		$sql .= " , ".$this->id_list." ";
		$sql .= ")";

		$this->db->begin();
		$resql = $this->db->query($sql);
		//echo $sql."<br>";
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error avancement_travaux ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			return 1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'avancement_travaux WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 					= $this->db->fetch_object($resql);
				$this->rowid 			= $obj->rowid;
				$this->date_ 		 	= $this->db->jdate($obj->date_);
				$this->engin 			= $obj->engin;
				$this->nbr_heur 		= $obj->nbr_heur;
				$this->rendement_u 		= $obj->rendement_u;
				$this->rendement_ml 	= $obj->rendement_ml;
				$this->rendement_m2 	= $obj->rendement_m2;
				$this->rendement_m3 	= $obj->rendement_m3;
				$this->nature_travaux 	= $obj->nature_travaux;
				$this->observations 	= $obj->observations;
				$this->id_list 		= $obj->id_list;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX . "avancement_travaux";

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		////echo $sql."<br>";

		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->rowid 			= $obj->rowid;
				$line->date_ 			= $this->db->jdate($obj->date_);
				$line->engin 			= $obj->engin;
				$line->nbr_heur 		= $obj->nbr_heur;
				$line->rendement_u 		= $obj->rendement_u;
				$line->rendement_ml 	= $obj->rendement_ml;
				$line->rendement_m2 	= $obj->rendement_m2;
				$line->rendement_m3 	= $obj->rendement_m3;
				$line->nature_travaux 	= $obj->nature_travaux;
				$line->observations 	= $obj->observations;
				$line->id_list 		= $obj->id_list;
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'avancement_travaux' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		//echo $sql."<br>";

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'avancement_travaux' .' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		//echo $sql."<br>";

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	public function get_part_date($dt = 'year' ,$filter = '')
	{
		$sql = "SELECT distinct ".$dt."(`date_`) as 'part' FROM ";
		$sql .= MAIN_DB_PREFIX . "avancement_travaux";

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}

		$resql = $this->db->query($sql);
		$dates = array();

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$dates[ $obj->part ] = $obj->part;
			}
			$this->db->free($resql);
			return $dates;
		}
	}
}

?>