<?php
/* Copyright (C) 2005     	Rodolphe Quiedeville	<rodolphe@quiedeville.org>
 * Copyright (C) 2004-2013	Laurent Destailleur 	<eldy@users.sourceforge.net>
 * Copyright (C) 2005-2010	Regis Houssin       	<regis.houssin@capnetworks.com>
 * Copyright (C) 2010     	François Legastelois	<flegastelois@teclib.com>
 * Copyright (C) 2014-2015	Charlie BENKE			<charles.fr@benke.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file       /management/projet/reporttime.php
 *	\ingroup    projet
 *	\brief      show time used in project
 */

require ("../../../../main.inc.php");
require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
require_once DOL_DOCUMENT_ROOT.'/projet/class/task.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/project.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';

require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/management/core/lib/management.lib.php';

$langs->load('management@management');

$action=GETPOST('action');
$mode=GETPOST("mode");


$periodyear=GETPOST('periodyear','int');
if (!$periodyear)
	$periodyear=date('Y');

$periodmonth=GETPOST('periodmonth','int');
if ($periodmonth=="")
	$periodmonth=date('m');

$perioduser=GETPOST('perioduser','int');
if (!$perioduser)
	$perioduser=$user->id;

$displaymode=GETPOST('displaymode','int');
if (!$displaymode)
	$displaymode=0;

	
// récupération du nombre de jour dans le mois
$time = mktime(0, 0, 0, $periodmonth+1, 1, $periodyear); // premier jour du mois suivant
$time--; // Recule d'une seconde
$nbdaymonth=date('d', $time); // on récupère le dernier jour

$projectid='';
$projectid=GETPOST("id");
$projectref=GETPOST("ref");

$object = new Project($db);
$result = $object->fetch($projectid, $projectref);

if(!$projectid)
	$projectid=$object->id;

// Security check
$socid=0;
if ($user->societe_id > 0) $socid=$user->societe_id;
$result = restrictedArea($user, 'projet', $projectid);

$form=new Form($db);
$formother = new FormOther($db);
$projectstatic = new Project($db);
$taskstatic = new Task($db);


$tasksarray=$taskstatic->getTasksArray(0,0,$projectid,$socid,0);    // We want to see all task of project i am allowed to see, not only mine. Later only mine will be editable later.
$projectsrole=$taskstatic->getUserRolesForProjectsOrTasks($user,0,$projectid,0);
$tasksrole=$taskstatic->getUserRolesForProjectsOrTasks(0,$user,$projectid,0);


/*
 * Actions
 */


/*
 * View
 */


$form = new Form($db);

$title=$langs->trans("TimeSpentStat");

llxHeader("",$title,"");


if ($object->societe->id > 0)  $result=$object->societe->fetch($object->societe->id);

$head = project_prepare_head($object);
dol_fiche_head($head, 'management', $langs->trans("projet"), 0, 'project');

print '<table class="border" width="100%">';

$linkback = '<a href="'.DOL_URL_ROOT.'/projet/liste.php">'.$langs->trans("BackToList").'</a>';

$urlparam =($periodyear ? "&periodyear=".$periodyear:''). "&periodmonth=".$periodmonth.($perioduser ? "&perioduser=".$perioduser:'').($displaymode ? "&displaymode=".$displaymode:'');

print '<tr><td width="30%">'.$langs->trans("Ref").'</td><td>';
// Define a complementary filter for search of next/prev ref.
if (! $user->rights->projet->all->lire)
{
    $projectsListId = $object->getProjectsAuthorizedForUser($user,$mine,0);
    $object->next_prev_filter=" rowid in (".(count($projectsListId)?join(',',array_keys($projectsListId)):'0').")";
}
print $form->showrefnav($object, 'ref', $linkback, 1, 'ref', 'ref','', $urlparam);
print '</td></tr>';

print '<tr><td>'.$langs->trans("Label").'</td><td>'.$object->title.'</td></tr>';

print '<tr><td>'.$langs->trans("ThirdParty").'</td><td>';
if (! empty($object->societe->id)) print $object->societe->getNomUrl(1);
else print '&nbsp;';
print '</td></tr>';

// Visibility
print '<tr><td>'.$langs->trans("Visibility").'</td><td>';
if ($object->public) print $langs->trans('SharedProject');
else print $langs->trans('PrivateProject');
print '</td></tr>';

// Statut
print '<tr><td>'.$langs->trans("Status").'</td><td>'.$object->getLibStatut(4).'</td></tr>';

print '</table>';

print "<br>";



//$projectsListId = $projectstatic->getProjectsAuthorizedForUser($user,$mine,1);
//var_dump($tasksarray);
//var_dump($projectsrole);
//var_dump($taskrole);

dol_htmloutput_mesg($mesg);

// 

print '<form name="selectperiod" method="POST" action="'.$_SERVER["PHP_SELF"].'?id='.$projectid.'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="selectperiod">';

print '<table  width="50%" >';
print '<tr >';
print '<td>'.$langs->trans("PeriodAAAAMMUser").'</td>';

print '<td>'.$formother->selectyear($periodyear,'periodyear',0,5,1).'&nbsp;'.$formother->select_month($periodmonth,'periodmonth',1).'</td>';

$showempty=0;
if($user->rights->management->readuser)
	$showempty=1;

// attention le dernier paramétre n'est dispo que sur la 3.7 et le patch fournis
print '<td>'.$form->select_dolusers($perioduser,'perioduser',$showempty, '', 0,'', '', 0, 0, 0, " AND (u.rowid = ".$user->id." OR fk_user=".$user->id.')').'</td>';
print "</tr>\n";

print '<tr >';
print '<td>'.$langs->trans("DataToDisplay").'</td>';
$arraymode=array($langs->trans("TimePassed"), $langs->trans("TimeCost"), $langs->trans("TimeSell"), $langs->trans("Margin"));
print '<td>'.$form->selectarray('displaymode', $arraymode, $displaymode).'</td>';

print '<td ><input type=submit name="select"></td>';
print "</tr>\n";
print "</table>";
print '</form>';

$transfertarray=Array();

if ($periodmonth !="0")	// vue mensuel
{
	print '<table class="noborder" width="100%">';
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td>'.$langs->trans("Project").' / '.$langs->trans("RefTask").'</td>';
	print '<td align="right">'.$langs->trans("Status").'</td>';

	for ($day=1;$day <= $nbdaymonth ;$day++)
	{
		$curday=mktime(0, 0, 0, $periodmonth, $day, $periodyear);
		print '<td align=right>';
		print substr($langs->trans(date('l', $curday)),0,1)." ".$day.'</td>';
	}
	print "<td align=right>".$langs->trans("Total")."</td>";
	print "</tr>\n";

	timesheetLines($j, 0, $tasksarray, $level, $projectsrole, $tasksrole, $mine,$perioduser);
	print "</table>";
}
else	// vue annuel
{
	print '<table class="noborder" width="100%">';
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td>'.$langs->trans("Project").' / '.$langs->trans("RefTask").'</td>';
	print '<td align="right">'.$langs->trans("Status").'</td>';
	$montharray = monthArray($langs);
	for ($month=1;$month<= 12 ;$month++)
		print '<td align=right>'.$montharray[$month].'</td>';

	print '<td align="right">'.$langs->trans("Total").'</td>';
	print "</tr>\n";
	timesheetYear($j, 0, $tasksarray, $level, $projectsrole, $tasksrole, $mine,$perioduser);
	print "</table>";	
}


// si il y a des choses à facturer

llxFooter();
$db->close();


/**
 * Output a task line
 *
 * @param	string	   	&$inc			?
 * @param   string		$parent			?
 * @param   Object		$lines			?
 * @param   int			&$level			?
 * @param   string		&$projectsrole	?
 * @param   string		&$tasksrole		?
 * @param   int			$mytask			0 or 1 to enable only if task is a task i am affected to
 * @return  $inc
 */
function timesheetLines(&$inc, $parent, $lines, &$level, &$projectsrole, &$tasksrole, $mytask=0, $perioduser='')
{
	global $bc, $langs;
	global $form, $projectstatic, $taskstatic;
	global $periodyear, $periodmonth, $nbdaymonth, $displaymode ;

	global $transfertarray;

	$lastprojectid=0;

	$totalcol = array();
	$totalline = 0;

	$var=true;
	
	$numlines=count($lines);
	for ($i = 0 ; $i < $numlines ; $i++)
	{
		if ($parent == 0) $level = 0;

		if ($lines[$i]->fk_parent == $parent)
		{

			// Break on a new project
			if ($parent == 0 && $lines[$i]->fk_project != $lastprojectid)
			{
				$totalprojet = array();
				$var = !$var;
				$lastprojectid=$lines[$i]->fk_project;
			}

			print "<tr ".$bc[$var].">\n";
			// Ref
			print '<td>';
			$taskstatic->fetch($lines[$i]->id);
			$taskstatic->label=$lines[$i]->label." (".dol_print_date($lines[$i]->date_start,'day')." - ".dol_print_date($lines[$i]->date_end,'day').')'	;
			print $taskstatic->getNomUrl(1,($showproject?'':'withproject'));
			print '</td>';
			// Progress
			print '<td align="right">';
			print $lines[$i]->progress.'% ';
			// si transférable en facturation on conserve dans un tableau
			if ($taskstatic->fk_statut == 3)
				$transfertarray[] = $lines[$i]->id;
			print $taskstatic->getLibStatut(3);
			print '</td>';
			$totalline = 0;
			for ($day=1;$day <= $nbdaymonth;$day++)
			{
				$curday=mktime(0, 0, 0, $periodmonth, $day, $periodyear);
				$bgcolor="";
				if (date('N', $curday) == 6 || date('N', $curday) == 7)
					$bgcolor=" bgcolor=grey ";
					
				$szvalue = fetchSumTimeSpent($taskstatic->id, $curday, $perioduser, $displaymode);
				
				$totalline+=$szvalue;
				$totalprojet[$day]+=$szvalue;
				if ($displaymode==0)
					print '<td '.$bgcolor.' align=right>'.($szvalue ? convertSecondToTime($szvalue, 'allhourmin'):"").'</td>';
				else
					print '<td '.$bgcolor.' align=right>'.($szvalue ? price($szvalue):"").'</td>';
				// le nom du champs c'est à la fois le jour et l'id de la tache
			}
			// total line
			if ($displaymode==0)
				print '<td  align=right>'.($totalline ? convertSecondToTime($totalline, 'allhourmin'):"").'</td>';
			else
				print '<td  align=right>'.($totalline ? price($totalline):"").'</td>';


			// Break on a new project
			if ($parent == 0 && $lines[$i+1]->fk_project != $lastprojectid)
			{
				print "<tr class='liste_total'>\n";
				print '<td colspan=2 align=right><b>Total</b></td>';
				print '</td>';
				$totalline = 0;
				for ($day=1;$day <= $nbdaymonth;$day++)
				{
					$curday=mktime(0, 0, 0, $periodmonth, $day, $periodyear);
					$bgcolor="";
					if (date('N', $curday) == 6 || date('N', $curday) == 7)
						$bgcolor=" bgcolor=grey ";
					// on affiche le total du projet
					if ($displaymode==0)
						print '<td '.$bgcolor.' align=right><b>'.($totalprojet[$day] ? convertSecondToTime($totalprojet[$day], 'allhourmin'):"").'</b></td>';
					else
						print '<td '.$bgcolor.' align=right><b>'.($totalprojet[$day] ? price($totalprojet[$day]):"").'</b></td>';
					$totalline+=$totalprojet[$day];
				}
				
				// total line
				if ($displaymode==0)
					print '<td  align=right><b>'.($totalline ? convertSecondToTime($totalline, 'allhourmin'):"").'</b></td>';
				else
					print '<td  align=right><b>'.($totalline ? price($totalline):"").'</b></td>';
				print "</tr>\n";
			}			
			$inc++;
			$level++;
			if ($lines[$i]->id) timesheetLines($inc, $lines[$i]->id, $lines, $level, $projectsrole, $tasksrole, $mytask, $perioduser);
			$level--;
		}
		else
		{
			//$level--;
		}

	}

	return $inc;
}

/**
 * Output a task line
 *
 * @param	string	   	&$inc			?
 * @param   string		$parent			?
 * @param   Object		$lines			?
 * @param   int			&$level			?
 * @param   string		&$projectsrole	?
 * @param   string		&$tasksrole		?
 * @param   int			$mytask			0 or 1 to enable only if task is a task i am affected to
 * @return  $inc
 */
function timesheetYear(&$inc, $parent, $lines, &$level, &$projectsrole, &$tasksrole, $mytask=0, $perioduser='')
{
	global  $bc, $langs;
	global $form, $projectstatic, $taskstatic;
	global $periodyear, $displaymode ;

	global $transfertarray;

	$lastprojectid=0;
	$totalcol = array();
	$totalline = 0;
	$var=true;

	$numlines=count($lines);
	for ($i = 0 ; $i < $numlines ; $i++)
	{
		if ($parent == 0) $level = 0;

		if ($lines[$i]->fk_parent == $parent)
		{

			// Break on a new project
			if ($parent == 0 && $lines[$i]->fk_project != $lastprojectid)
			{
				$totalprojet = array();
				$var = !$var;
				$lastprojectid=$lines[$i]->fk_project;
			}

			print "<tr ".$bc[$var].">\n";
			// Ref
			print '<td>';
			$taskstatic->fetch($lines[$i]->id);
			$taskstatic->label=$lines[$i]->label." (".dol_print_date($lines[$i]->date_start,'day')." - ".dol_print_date($lines[$i]->date_end,'day').')'	;
			//print $taskstatic->getNomUrl(1);
			print $taskstatic->getNomUrl(1,($showproject?'':'withproject'));
			print '</td>';

			// Progress
			print '<td align="right">';
			print $lines[$i]->progress.'% ';
			print $taskstatic->getLibStatut(3);
			
			if ($taskstatic->fk_statut == 3)
				$transfertarray[] = $lines[$i]->id;

			print '</td>';

			$totalline = 0;
			for ($month=1;$month<= 12 ;$month++)
			{
				$szvalue = fetchSumMonthTimeSpent($taskstatic->id, $month, $periodyear, $perioduser, $displaymode);
				$totalline+=$szvalue;
				$totalprojet[$month]+=$szvalue;
				if ($displaymode==0)
					print '<td align=right>'.($szvalue ? convertSecondToTime($szvalue, 'allhourmin'):"").'</td>';
				else
					print '<td align=right>'.($szvalue ? price($szvalue):"").'</td>';
				// le nom du champs c'est à la fois le jour et l'id de la tache
			}
			if ($displaymode==0)
				print '<td align=right>'.($totalline ? convertSecondToTime($totalline, 'allhourmin'):"").'</td>';
			else
				print '<td align=right>'.($totalline ? price($totalline):"").'</td>';


			$inc++;
			$level++;
			if ($lines[$i]->id) timesheetYear($inc, $lines[$i]->id, $lines, $level, $projectsrole, $tasksrole, $mytask, $perioduser);
			$level--;

		}
		else
		{
			//$level--;
		}

	}
	
	if ($level == 0)
	{
		print "<tr class='liste_total'>\n";
		print '<td colspan=2 align=right><b>Total</b></td>';
		print '</td>';
		$totalline = 0;
		for ($month=1;$month<= 12 ;$month++)
		{
			// on affiche le total du projet
			if ($displaymode==0)
				print '<td align=right>'.($totalgen[$month] ? convertSecondToTime($totalgen[$month], 'allhourmin'):"").'</td>';
			else
				print '<td align=right>'.($totalgen[$month] ? price($totalgen[$month]):"").'</td>';

			$totalline+=$totalgen[$month];
		}
		// on affiche le total du projet
		if ($displaymode==0)
			print '<td align=right>'.($totalline ? convertSecondToTime($totalline, 'allhourmin'):"").'</td>';
		else
			print '<td align=right>'.($totalline ? price($totalline):"").'</td>';

		print "</tr>\n";
	}
	return $inc;
}

?>
