<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres//approval/index.php
 * \ingroup    list
 * \brief      List of approval related to given AO
 */
require_once('../../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/class/appeloffre.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/approval/class/approval.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/lib/marches.lib.php';

$langs->load('users');
$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page 	   = GETPOST("page",'int');
$page 	   = is_numeric($page) ? $page : 0;
$page 	   = $page == -1 ? 0 : $page;
$filter    = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset  = $conf->liste_limit * $page;
$pageprev= $page - 1;
$pagenext= $page + 1;
$action	 = GETPOST('action', 'alpha');
$confirm = GETPOST('confirm', 'alpha');
$ao 	 = GETPOST('ao', 'int');
$id 	 = GETPOST('id', 'int');

if (!$ao)
	die('ID Appel offre n\'existe pas!');

/**
 * Actions
 */

// None

/**
 * View
 */

$approval 	= new Approval($db);
$appeloffre = new AppelOffre($db);
$filter 	= '';

if ($id > 0 || $ao > 0) {
	$approval->fetch($id, $ao);
		
	if (!$approval->id)
		$approval->fetch(null, $ao);
	$object 	= $approval;
    $param 		= '&ao='. $ao;

	$upload_dir = $conf->marches->dir_output.'/approval/'.$approval->id;
	$modulepart = 'marches';

	$filearray = array();

	// Construit liste des fichiers
	$filearray = dol_dir_list($upload_dir, "files", 0, '', '(\.meta|_preview\.png)$', $sortfield, (strtolower($sortorder)=='desc'?SORT_DESC:SORT_ASC),1);
	$totalsize=0;
	foreach($filearray as $key => $file) {
		$totalsize+=$file['size'];
	}

	include_once DOL_DOCUMENT_ROOT . '/btp/nc_under_modules/marches/core/tpl/document_actions_pre_headers.tpl.php';
}

llxHeader(array(), $langs->trans('ListOfApproval'));

// Récupération de l'ID de l'utilisateur
$user_id 	 = $user->id;
$getApproval = $approval->fetchAll($ao);

// Si erreur SQL
if ($getApproval == '-1') {
    print_fiche_titre($langs->trans('ListOfApproval'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$approval->error);
    exit();
}

// Show table of vacations
$var 		= true;
$num 		= count($approval->lines);
$form 		= new FormChild($db);

if (($id > 0 || $ao > 0) && $getApproval > 0) {

	if (GETPOST('notification')) {
        $notif = '';
        switch(GETPOST('notification')) {
            case 'marketCreated' :
                $notif = $langs->trans('marketCreatedAuto');
                break;
            case 'marketDeleted' :
                $notif = $langs->trans('marketDeleted');
                break;
            case 'marketArchived' :
                $notif = $langs->trans('marketArchived');
                break;
            case 'marketActivated' :
                $notif = $langs->trans('marketActivated');
                break;
        }

        setEventMessage($notif);
    }

	$approval->fetch($id, $ao);
		
	if (!$approval->id)
		$approval->fetch(null, $ao);

	$appeloffre->fetch($ao);
	$object 	= $approval;
	$title = $langs->trans("ListOfApproval");
	$head  = appeloffre_prepare_head($appeloffre);
	dol_fiche_head($head, 'approval', $title, 0, '');

	echo $appeloffre->getAppelOffreHeader();

	$createdBy  = new User($db);
	$createdBy->fetch($approval->fk_created_by);
	
	$amount_ht 		  = $approval->amount_ht ? number_format($approval->amount_ht, 2) : '';
	$amount_tva		  = $approval->amount_tva ? number_format($approval->amount_tva, 2) : '';
	$amount_ttc	  	  = $approval->amount_ttc ? number_format($approval->amount_ttc, 2) : '';
	$signature_num	  = $approval->signature_num ? $approval->signature_num : '';
	$signature_date	  = $approval->signature_date ? dol_print_date($approval->signature_date, 'day') : '';
	$approval_num	  = $approval->approval_num ? $approval->approval_num : '';
	$approval_date	  = $approval->approval_date ? dol_print_date($approval->approval_date, 'day') : '';
	$visa_num	  	  = $approval->visa_num ? $approval->visa_num : '';
	$visa_date	  	  = $approval->visa_date ? dol_print_date($approval->visa_date, 'day') : '';
	$approved	  	  = $approval->approved ? 1 : 0;
	$created_at 	  = null !== $approval->created_at ? dol_print_date($approval->created_at,'dayhoursec') : '';
	$bail_date 	  	= null !== $approval->bail_date ? dol_print_date($approval->bail_date,'day') : '';
	$bail_amount	  = $approval->bail_amount ? number_format($approval->bail_amount, 2) : '';
	$bail_num	  	  = $approval->bail_num ? $approval->bail_num : '';

	print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';
        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalAmountHT").'</td><td>'. $amount_ht.' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
        
        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalAmountTva").'</td><td>'. $amount_tva.' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
        
        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalAmountTTC").'</td><td>'. $amount_ttc.' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';

        print '<tr><td class="" width="400px">'.$langs->trans("ApprovalDateSigMarket").'</td><td>' . ucfirst($signature_num) .' &nbsp;&nbsp; '. $langs->trans("ApprovalDateAt").' &nbsp;&nbsp; '. $signature_date;
        print '</td></tr>';

        print '<tr><td>'.$langs->trans("ApprovalDateApprov").'</td><td>'. ucfirst($approval_num) .' &nbsp;&nbsp; '. $langs->trans("ApprovalDateAt").' &nbsp;&nbsp; '. $approval_date;
        print '</td></tr>';

        print '<tr><td>'.$langs->trans("ApprovalDateNumVisa").'</td><td>'. $visa_num. ' &nbsp;&nbsp; '. $langs->trans("ApprovalDateAt").' &nbsp;&nbsp; '. $visa_date;
        print '</td></tr>';

        print '<tr><td>'.$langs->trans("Approved").'</td><td>'. $approval->statusLevel($approved) .'</td></tr>';

        if (!$approved) {
	        print '<tr class="hidden bail_info"><td>'.$langs->trans("ApprovalBailNum").'</td><td>'. $bail_num .'</td></tr>';
	        print '<tr class="hidden bail_info"><td>'.$langs->trans("ApprovalBailDate").'</td><td>'. $bail_date .'</td></tr>';
	        print '<tr class="hidden bail_info"><td>'.$langs->trans("ApprovalBailAmount").'</td><td>'. $bail_amount .'</td></tr>';
        }
     	print '</tbody>';
	print '</table>';

	if ($user->id && $user->rights->marches->write_all) {
		print '<div class="tabsAction">';
        // Boutons d'actions
		print '<a href="./card.php?action=edit&ao='. $ao .'&id='. $approval->id .'" class="butAction">'.$langs->trans('Modify').'</a>';
        print '</div>';
	}

	$modulepart = 'marches';
    $permission = $user->rights->marches->write;
    $param 		            = '&ao='. $ao;
    $relativepathwithnofile = '/approval/'.$approval->id.'/';

    include_once DOL_DOCUMENT_ROOT . '/btp/nc_under_modules/marches/core/tpl/document_actions_post_headers.tpl.php';
}

if ($user->id && $user->rights->marches->write && $getApproval <= 0) {
	$appeloffre->fetch($ao);
	$object 	= $approval;
	$title = $langs->trans("ListOfApproval");
	$head  = appeloffre_prepare_head($appeloffre);
	dol_fiche_head($head, 'approval', $title, 0, '');
	print '<br>';
	print '<div style="text-align: center; margin-top: 8px;">';
	print '<a href="./card.php?action=add&ao='. $ao .'" class="butAction">'.$langs->trans('AddApproval').'</a>';
	print '</div>';
}

llxFooter();

$db->close();

?>