<?php

/* Copyright (C) 2016      Yassine Belkaid <y.belkaid@nextcincept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *      \file       htdocs/marches/certificates/class/chargesociles.class.php
 *		\ingroup    certificates
 *		\brief      Fichier de la classe des charges sociales
 */
require_once DOL_DOCUMENT_ROOT . '/btp/nc_under_modules/marches/db/nxdb.class.php';


/**     \class      CertifcatesChargeSociales
 *		\brief      Classe permettant la gestion des paiements des charges
 *                  La tva collectee n'est calculee que sur les factures payees.
 */
class Certificates extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see marches::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'm_certificates';
	/**
	 * @var string Name of table without pref_marcheix where object is stored
	 */
	public $table_element = 'm_certificates';

	/**
	 * @var int ID
	 */
	public $id;
	public $fk_created_by;
	public $fk_marche;
	public $fk_chargesociales;
	public $statut;
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->ref 			= $this->ref ? $this->db->escape($this->ref): null;
		$this->fk_created_by= $this->fk_created_by ?: null;
		$this->fk_marche 	= $this->fk_marche ?: null;
		$this->fk_chargesociales= $this->fk_chargesociales ?: null;
		$this->created_at 	= $this->now;
		
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_created_by, fk_marche, fk_chargesociales, created_at, updated_at) VALUES (';		
		$sql .= $this->fk_created_by.', '.$this->fk_marche.', '.$this->fk_chargesociales.', "'.$this->created_at.'", "'.$this->updated_at .'")';

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error Notification ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $chargesocial_id = null, $mid = null)
	{
		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (null !== $chargesocial_id) {
			$sql .= ' WHERE fk_chargesociales = ' . $chargesocial_id .' AND fk_marche = '. $mid;
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj 				 = $this->db->fetch_object($resql);
				$this->id 			 = $obj->rowid;
				$this->fk_created_by = $obj->fk_created_by;
				$this->fk_marche 	 = $obj->fk_marche;
				$this->fk_chargesociales= $obj->fk_chargesociales;
				$this->statut  		 = $obj->statut;
				$this->updated_at 	 = $this->db->jdate($obj->updated_at);
				$this->created_at 	 = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($mid, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		$sql = 'SELECT c.*, ch.libelle as label FROM ' . MAIN_DB_PREFIX . $this->table_element . ' as c, '.MAIN_DB_PREFIX .'chargesociales as ch';

		if (!empty($filter)) {
			$sql .= ' WHERE c.fk_marche = '. $mid . $filter;
		} else {
			$sql .= ' WHERE fk_marche = '. $mid;
		}
		
		$sql .= ' AND ch.rowid = c.fk_chargesociales';
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			 = $obj->rowid;
				$line->fk_created_by = $obj->fk_created_by;
				$line->fk_marche 	 = $obj->fk_marche;
				$line->fk_chargesociales= $obj->fk_chargesociales;
				$line->statut 		 = $obj->statut;
				$line->label 		 = $obj->label;
				$line->updated_at 	 = $this->db->jdate($obj->updated_at);
				$line->created_at 	 = $this->db->jdate($obj->created_at);
				$this->lines[] 		 = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET updated_at = "'. $this->now .'",';

			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= ' `'. $key. '` = '. $val .',';
			}

			$sql  = substr($sql, 0, -1);
			$sql .= ' WHERE rowid = ' . $id;

			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto=0,  $id, $mid = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef	= '';

        $ref = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = /*$langs->trans("Show").': '.*/ $ref;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/nc_under_modules/marches/certificates/index.php?id='. $id .'&mid='. $mid .'" class="classfortooltip" title="'. $label .'">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$label.$linkend;
        return $result;
    }
}