<?php

/* Copyright (C) 2016      Yassine Belkaid <y.belkaid@nextcincept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *      \file       htdocs/marches/certificates/class/chargesociles.class.php
 *		\ingroup    certificates
 *		\brief      Fichier de la classe des charges sociales
 */
require_once DOL_DOCUMENT_ROOT.'/compta/sociales/class/chargesociales.class.php';


/**     \class      CertifcatesChargeSociales
 *		\brief      Classe permettant la gestion des paiements des charges
 *                  La tva collectee n'est calculee que sur les factures payees.
 */
class CertifcatesChargeSociales extends ChargeSociales
{
	public $chargesociales = array(); 
	public function __construct($db) {
		 parent::__construct($db);
	}

	/**
     *  Get charge sociales by Type
     *
     *  @param	int     $id		Id
     *  @return	int <0 KO >0 OK
     */
    function fetchByType($id)
    {
        $sql = "SELECT cs.rowid, DATE_FORMAT(cs.date_ech, '%Y-%m-%d') as date_ech,";
        $sql.= " cs.libelle as lib, cs.fk_type, cs.amount, cs.paye, cs.periode,";
        $sql.= " c.libelle";
        $sql.= " FROM ".MAIN_DB_PREFIX."chargesociales as cs, ".MAIN_DB_PREFIX."c_chargesociales as c";
        $sql.= " WHERE cs.fk_type = c.id AND cs.fk_type = ".$id;

        dol_syslog(get_class($this)."::fetchByType", LOG_DEBUG);
        $resql=$this->db->query($sql);
        
        if ($resql) {
            if ($num = $this->db->num_rows($resql)) {
            	while ($obj = $this->db->fetch_object($resql)) {
            		$object  = new stdClass;  
            		$object->id             = $obj->rowid;
	                $object->ref            = $obj->rowid;
	                $object->lib            = $obj->lib;
	                $object->type           = $obj->fk_type;
	                $object->type_libelle   = $obj->libelle;
	                $object->amount         = $obj->amount;
	                $object->paye           = $obj->paye;
	                $object->date_ech       = $this->convertToFrDate($obj->date_ech);
	                $object->periode        = $this->convertToFrDate($obj->periode);
	                $this->chargesociales[] = $object;
            	}
                $this->db->free($resql);

                return $this->chargesociales;
            }
            else {
                return 0;
            }
        } else {
            $this->error=$this->db->lasterror();
            return -1;
        }
    }

    public function convertToFrDate($date)
    {
    	list($y, $m, $d) = explode("-", $date);

    	return $d.'/'.$m.'/'.$y;
    }
}