<?php 
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/competitors/card.php
 *		\ingroup    card
 *		\brief      Gestion des concurrents
 */

require_once('../../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/CMailFile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formmail.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/class/appeloffre.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/competitors/class/competitor.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/lib/marches.lib.php';

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$competitor_id = GETPOST('competitor_id', 'int');
$request_method =$_SERVER['REQUEST_METHOD'];

if ((empty($id) || $id <= 0) && $request_method !== 'POST')
	die('ID Appel offre n\'existe pas!');

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	= false;
$competitors = new Competitors($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {

    // If no right to create a request
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='request';
    }

    $id 	 = trim(GETPOST('id', 'int'));
    $awarded = trim(GETPOST('awarded', 'int'));

    if (!$id)
    	return false;

    $getCompetitors = $competitors->fetchAll($id);
    $winnerAlreadyTaken = false;

    if ($getCompetitors > 0) {
    	foreach ($competitors->lines as $key => $line) {
    		if ($line->winner) {
    			$winnerAlreadyTaken = true;
    		}
    	}
    }

    foreach ($_POST['name'] as $key => $name) {
	    $amount = $_POST['amount'][$key];
	    $city   = $_POST['city'][$key];
	    $address= $_POST['address'][$key];
	    $country= $_POST['country'][$key];
	    $winner = ($key == $awarded && !$winnerAlreadyTaken) ? 1 : 0;

	    $competitors->fk_created_by  = $user->id;
	    $competitors->fk_appel_offre = $id;
	    $competitors->name 		= $name;
	    $competitors->city 		= $city;
	    $competitors->address	= $address;
	    $competitors->country	= $country;
		$competitors->amount 	= str_replace(" ", "", $amount);
		$competitors->winner    = $winner;

		$getQualifId = $competitors->create();
    }

    // If no SQL error we redirect to the request card
    header('Location: ./index.php?id='.$id);
    die();
}

if ($_POST['action'] == 'update' && $_POST['competitor_id'] > 0 && $_POST['id'] > 0 && $request_method === 'POST') {

	// If no right to create a request
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='add';
    } else {
	    $id  			= trim(GETPOST('id', 'int'));
	    $competitor_id  = trim(GETPOST('competitor_id', 'int'));
	    $name 	 		= trim(GETPOST('name'));
	    $amount 	 	= trim(GETPOST('amount'));
	    $city 		 	= trim(GETPOST('city'));
	    $address 	 	= trim(GETPOST('address'));
	    $country 	 	= trim(GETPOST('country'));
	    $winner 	 	= trim(GETPOST('winner', 'int'));
	    $winnerAlreadyTaken = false;
		$getCompetitors = $competitors->fetchAll($id);

	    if (!$competitor_id)
	    	return;

	    if ($getCompetitors > 0) {
	    	foreach ($competitors->lines as $key => $line) {
	    		if ($line->winner) {
	    			$winnerAlreadyTaken = true;
	    		}
	    	}
	    }

	    $data = array(
	    	'name'	 => $name,
	    	'city'	 => $city,
	    	'address'=> $address,
	    	'country'=> $country,
			'amount' => $amount ? str_replace(" ", "", $amount) : 0,
			'winner' => $winnerAlreadyTaken ? 0 : 1
		);

		$getQualif = $competitors->update($competitor_id, $id, $data);

	    // If no SQL error we redirect to the request card
	    if ($getQualif > 0) {
	    	header('Location: ./index.php?id='.$id);
	        die();
	    } else {
	        // Otherwise we display the request form with the SQL error message
	        header('Location: ./card.php?action=request&error=SQL_Create&msg='.$competitors->error);
	        die();
	    }
	}
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' && $user->rights->marches->delete) {
	$error = 0;
	$id 		   = GETPOST('id', 'int');
	$competitor_id = GETPOST('competitor_id', 'int');
	
	if (!$id || !$competitor_id)
		return;

	$db->begin();

	$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $competitors->id = (int) $competitor_id;
        $competitors->fk_appel_offre = (int) $id;
		$competitors->delete();
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
		header('Location: ./index.php?leftmenu=marches&id='.$id);
		exit;
	} else {
		$db->rollback();
        header('Location: ./index.php?leftmenu=marches&id='.$id);
        exit;
	}
}

$form 	 	= new Form($db);
$appeloffre = new AppelOffre($db);
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/includes/jquery/plugins/timepicker/timepicker-fr.js", "/btp/nc_under_modules/marches/js/marches.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css", "/btp/nc_under_modules/marches/css/marches.css");

llxHeader(array(), $langs->trans('ListOfCompetitors'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {
        // Formulaire de concurrents
		$appeloffre->fetch($id);
		$head = appeloffre_prepare_head($appeloffre);
		dol_fiche_head($head, 'competitors', $langs->trans('AddCompetitor'), 0, '');

		if ($id > 0) {
			echo $appeloffre->getAppelOffreHeader();
		}

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";
        print '<input id="awarded" type="hidden" name="awarded" value="" />'."\n";

        print '<div id="competitors_wrapper"><table class="row-0 rows-num mrg-btm-10 border" width="100%" data-row-id="0">';
        print '<tbody>';
        // Name
        print '<tr><td class="fieldrequired">'.$langs->trans("CompetitorName").'</td><td>';
        print '<input type="text" class="comp_name" value="" name="name[]" required="required" />';
        print '<a href="javascript:;void(0)" class="delete_img hidden"><img src="'.DOL_URL_ROOT.'/theme/'. $conf->theme .'/img/delete.png" /></a>';
        print '</td></tr>';
        print '<tr><td>'.$langs->trans("City").'</td><td><input type="text" class="comp_city" value="" name="city[]" /></td></tr>';
        print '<tr><td>'.$langs->trans("Address").'</td><td><input type="text" class="comp_address" value="" name="address[]" /></td></tr>';
        print '<tr><td>'.$langs->trans("Country").'</td><td><input type="text" class="comp_country" value="" name="country[]" /></td></tr>';
        // Amount
        print '<tr><td class="fieldrequired">'.$langs->trans("Amount").'</td><td><input type="text" class="comp_amount"  required="required" value="" name="amount[]" /></td></tr>';
        // Winner
        print '<tr><td>'.$langs->trans("Winner").'</td><td>';
        print '<input type="checkbox" value="1" class="comp_winner" name="winner[]" /> ';
        print '</td></tr>';
        print '</tbody>';
        print '</table></div>';

        print '<div style="float: left; margin-top: 5px;">';
		print '<a id="addMoreCompetitors" href="javascript:void(0);" class="butAction">'.$langs->trans('AddNewLine').'</a>';
		print '</div><br /><br /><br />';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateCompetitor") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    }
} else {
	if ($competitor_id > 0 && $id > 0) {
		$competitors->fetch($competitor_id, $id);
		$appeloffre->fetch($id);
		$head  = appeloffre_prepare_head($appeloffre);
		dol_fiche_head($head, 'competitors', $langs->trans('AddCompetitor'), 0, '');
		$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

		if ($id > 0) {
			echo $appeloffre->getAppelOffreHeader();
		}

		if ($canedit) {
            if ($action == 'delete') {
                if($user->rights->marches->delete) {
                    print $form->formconfirm("./card.php?id=".$id."&competitor_id=".$competitor_id, $langs->trans("TitleDeleteComp"),$langs->trans("ConfirmDeleteComp"),"confirm_delete", '', 0, 1);
                }
            }

			if ($action == 'edit' || $action == 'delete') {
				$checked = $competitors->winner == 1 ? ' checked="checked"' : '';
		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";
		        print '<input type="hidden" name="competitor_id" value="'. $competitor_id .'" />'."\n";

		        print '<table class="border" width="100%">';
		        print '<tbody>';
		        // Name
		        print '<tr><td class="fieldrequired">'.$langs->trans("CompetitorName").'</td><td>';
		        print '<input type="text" value="'. $competitors->name .'" name="name" required="required" />';
		        print '</td></tr>';
		        print '<tr><td>'.$langs->trans("City").'</td><td><input type="text" class="comp_city" value="'. $competitors->city .'" name="city" /></td></tr>';
		        print '<tr><td valign="top">'.$langs->trans("Address").'</td><td><textarea cols="50" rows="4" class="comp_address" name="address">'. nl2br($competitors->address) .'</textarea></td></tr>';
		        print '<tr><td>'.$langs->trans("Country").'</td><td><input type="text" class="comp_country" value="'. $competitors->country .'" name="country" /></td></tr>';
		        // Amount
		        print '<tr><td class="fieldrequired"
>'.$langs->trans("Amount").'</td><td>';
		        print '<input type="text" value="'. $competitors->amount .'" name="amount" required="required" />';
		        print '</td></tr>';
		        // Winner
		        print '<tr><td>'.$langs->trans("Winner").'</td><td>';
		        print '<input class="check_winner" type="checkbox" value="1" name="winner"'. $checked .' /> ';
		        print '</td></tr>';
		        print '</tbody>';
		        print '</table><br /><br />';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';

                    // If draft
                    if ($user->rights->marches->delete)	{
                    	print '<a href="./card.php?id='.$_GET['id'].'&action=delete&competitor_id='. $competitor_id .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>