<?php

/**
* A collection of Tools to be used throughout the app
*/
class Tools
{
	
	/**
     * Calculate TVA
     *
     * @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     * @return array
     */
    public static function getTva($ht, $percentage = 20)
    {
    	$tva = ($ht*$percentage)/100;
    	
    	return array(
    		'tva' 		 => (float) $tva,
    		'amount_ttc' => (float) ($ht+$tva)
    	);
    }

    /**
     * Fetch total days from given start date
     */
    public static function getTotalDaysTillEnd($execution_start_date, $end_date = null)
    {
    	if (!$execution_start_date)
    		return;

    	if (false !== strpos($execution_start_date, "/")) {
    		list($d, $m, $y) = explode("/", $execution_start_date);
    		$execution_start_date = $y.'-'.$m.'-'.$d;
    	}

    	$now       = new \DateTime("now");
    	$startDate = new \DateTime($execution_start_date);

    	if (null !== $end_date) {
    		$endDate = new \DateTime($end_date);
    		if ( self::checkEndDateExceeding($endDate, $now) )
    			$now = $endDate;
    	}

    	$getDays = self::getDiffOfDates($startDate, $now);

    	return $getDays;
    }

    /**
     * Get date difference
     */
    public static function getDiffOfDates($start_date, $end_date, $type = 'days')
    {
    	if (!($start_date instanceof DateTime))
    		$start_date = new \DateTime($start_date);

    	if (!($end_date instanceof DateTime))
    		$end_date = new \DateTime($end_date);

    	$diff = '';
    	
    	switch ($type) {
    		case 'days':
    			$diff = $start_date->diff($end_date)->days;
    			break;
    		default:
    			$diff = $start_date->diff($end_date)->days;
    			break;
    	}

    	return $diff;
    }
    /**
     * Check if end date exceeds the start date
     */
    public static function checkEndDateExceeding($start_date, $end_date)
    {
    	if (!($start_date instanceof DateTime))
    		$start_date = new \DateTime($start_date);

    	if (!($end_date instanceof DateTime))
    		$end_date = new \DateTime($end_date);

    	if ($end_date->getTimeStamp() > $start_date->getTimeStamp())
    		return true;
    	return false;
    }

    /**
     * Get period days if the given date is exceeding now
     */
    public static function checkPeriodExceeding($checked_date, $end_date = null)
    {
        if (null === $end_date) {
            $now = new \DateTime("now");
        } else {
            $now = new \DateTime($end_date);
        }
    	
    	if (!($checked_date instanceof DateTime))
    		$checked_date = new \DateTime($checked_date);

    	if ( self::checkEndDateExceeding($checked_date, $now) ) {
    		$getDiff = self::getDiffOfDates($checked_date, $now);
    		
    		return $getDiff;
    	}

    	return false;
    }

    public static function getEndDatFromDays($start_date, $months, $days)
    {
    	if (empty($start_date))
    		return;

    	if(false !== strpos($start_date, "/")) {
    		list($d, $m, $y) = explode("/", $start_date);
			$start_date = new \DateTime($y.'-'.$m.'-'.$d);
    	} else {
			$start_date = new \DateTime($start_date);
    	}

		$start_date->modify('+ '.$months.' months');
    
		if ($days)
			$start_date->modify('+ '.$days.' days');
    	
    	return $start_date;
    }

    public static function calculateRemainedAmountInPercentage($total, $sub_amount)
    {
    	return ((100*$sub_amount)/$total);
    }

    public static function convertDateTo($date, $format = 'fr')
    {
        $convertedDate = '';

        if (isset($date) && !empty($date)) {
            if ($format == 'sql') {
                list($d, $m, $y) = explode("/", trim($date));
                $convertedDate = $y.'-'.$m.'-'.$d;
            } else if ($format == 'fr') {
                list($y, $m, $d) = explode("-", trim($date));
                $convertedDate = $d .'/'. $m .'/'. $y;
            }
        }

        return $convertedDate;
    }

    public function trunc_words($string, $max = 5, $separator = '...')
    {
        $getStringAsArray = explode(" ", $string);

        if (count($getStringAsArray) <= $max)
            return $string;

        return implode(" ", array_slice($getStringAsArray, 0, $max)). $separator;
    }
}