<?php
/* Copyright (C) Yassine Belkaid  y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    marches/monitoring/.class.php
 * \ingroup marches
 * \brief   This file is monitoring CRUD class file
 *
 */

require_once DOL_DOCUMENT_ROOT . '/btp/nc_under_modules/marches/db/nxdb.class.php';

/**
 * Class marches
 *
 * Contract Management class
 */
class Monitoring extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see marches::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'm_monitoring';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'm_monitoring';

	/**
	 * @var int ID
	 */
	public $id;
	public $fk_created_by;
	public $fk_appel_offre;
	public $demand_num;
	public $demand_date;
	public $delay_justfication;
	public $response_st_num;
	public $response_st_date;
	public $observation;
	public $moyens;
	public $statut;
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
 
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		  = $db;
		$this->now 		  = new \DateTime("now");
		$this->now 		  = $this->now->format('Y-m-d H:i:s');
		$this->updated_at = $this->now;
		
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_appel_offre 		= $this->fk_appel_offre ?: null;
		$this->fk_created_by  		= $this->fk_created_by ?: null;
		$this->demand_num 			= $this->demand_num ?: null;
		$this->demand_date 			= $this->demand_date ?: null;
		$this->delay_justfication 	= $this->delay_justfication ?: null;
		$this->response_st_num 		= $this->response_st_num ?: null;
		$this->response_st_date 	= $this->response_st_date ?: null;
		$this->moyens 				= $this->moyens ? serialize($this->moyens) : null;
		$this->observation 			= $this->observation ?: null;
		$this->created_at 	  		= $this->now;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_appel_offre, fk_created_by, demand_num, demand_date, created_at, updated_at, delay_justfication, response_st_num, response_st_date, observation, moyens) VALUES (';
		$sql .= $this->fk_appel_offre.', '.$this->fk_created_by.', "'.$this->demand_num.'", "'.$this->demand_date.'", "'.$this->created_at.'", "'.$this->updated_at .'", "'.$this->delay_justfication.'", "'.$this->response_st_num.'", "'.$this->response_st_date.'", "'.$this->observation.'", \''. $this->moyens .'\')';

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->error 	= 'Error: ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $num num
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ao_id = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element. ' WHERE rowid = ' . $id .' AND fk_appel_offre = '. $ao_id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			  	  = $this->db->fetch_object($resql);
				$this->id 		  	  = $obj->rowid;
				$this->fk_appel_offre = $obj->fk_appel_offre;
				$this->fk_created_by  = $obj->fk_created_by;
				$this->demand_num 			= $obj->demand_num;
				$this->demand_date 			= $this->db->jdate($obj->demand_date);
				$this->delay_justfication 	= $obj->delay_justfication;
				$this->response_st_num 		= $obj->response_st_num;
				$this->response_st_date 	= $this->db->jdate($obj->response_st_date);
				$this->observation 			= nl2br($obj->observation);
				$this->moyens	  	  = unserialize($obj->moyens);
				$this->statut	  	  = $obj->statut;
				$this->updated_at 	  = $this->db->jdate($obj->updated_at);
				$this->created_at 	  = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($ao_id, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element . ' WHERE fk_appel_offre ='. (int) $ao_id;

		if (!empty($filter)) {
			$sql .= $filter;
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 		  	  	= $obj->rowid;
				$line->fk_appel_offre 	= $obj->fk_appel_offre;
				$line->fk_created_by  	= $obj->fk_created_by;
				$line->demand_num 		= $obj->demand_num;
				$line->demand_date 		= $this->db->jdate($obj->demand_date);
				$line->delay_justfication= $obj->delay_justfication;
				$line->response_st_num 	= $obj->response_st_num;
				$line->response_st_date = $this->db->jdate($obj->response_st_date);
				$line->observation 		= nl2br($obj->observation);
				$line->moyens	  	  = unserialize($obj->moyens);
				$line->statut	  	  = $obj->statut;
				$line->updated_at 	  = $this->db->jdate($obj->updated_at);
				$line->created_at 	  = $this->db->jdate($obj->created_at);
				$this->lines[] 	  	  = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, $ao_id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET ';

		if (count($data) && is_array($data)) {
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : "'". $this->db->escape($val) ."'";
				$sql .= '`'. $key. '` = '. $val .',';
			}
		} else 
			return;

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . (int) $id . ' AND fk_appel_offre ='. (int) $ao_id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . $this->id .' AND fk_appel_offre ='. $this->fk_appel_offre;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id, $monitoring_id, $num = null)
    {
        global $langs;

        $result	= '';
        $num = (null !== $num) ? $num : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $num;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/nc_under_modules/marches/monitorings/index.php?ao='. $id .'&id='. $monitoring_id .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$num.$linkend;
        return $result;
    }

}
