<?php 
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/qualifications/card.php
 *		\ingroup    card
 *		\brief      Gestion des qualifications et classification des entreprises
 */

require_once('../../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/CMailFile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formmail.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/qualifications/class/qualification.class.php';

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$error 	= false;
$qualifications = new Qualifications($db);

if ($_POST['action'] == 'create' && $_SERVER['REQUEST_METHOD'] === 'POST') {

    // If no right to create a request
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='request';
    }

    $defs  = array();
    $provs = array();
    // definitive
    if (count($_POST['def_sector'])) {
    	foreach ($_POST['def_sector'] as $key => $val) {
    		$qualification 	= $_POST['def_qualif'][$key];
    		$class 			= $_POST['def_class'][$key];

    		if (!$val && !$qualification && !$class)
    			continue;

    		$defs['sector'][] 		 = $val;
    		$defs['qualification'][] = $qualification;
    		$defs['class'][] 		 = $class;
    	}
    }

    // provisoire
    if (count($_POST['prov_sector'])) {
    	foreach ($_POST['prov_sector'] as $key => $val) {
    		$qualification 	= $_POST['prov_qualif'][$key];
    		$class 			= $_POST['prov_class'][$key];

    		if (!$val && !$qualification && !$class)
    			continue;

    		$provs['sector'][] 		  = $val;
    		$provs['qualification'][] = $qualification;
    		$provs['class'][] 		  = $class;
    	}
    }

    $num 	 = trim(GETPOST('num'));
    $type    = GETPOST('type');
    $subject = trim(GETPOST('subject'));
    $budget  = trim(GETPOST('budget_'));

    // Dates
    $delivered = null;
    $expired   = null;
    if (isset($_POST['delivered']) && !empty($_POST['delivered'])) {
        list($etd, $etm, $ety) = explode("/", $_POST['delivered']);
        $delivered = $ety.'-'.$etm.'-'.$etd;
    }
    
    if (isset($_POST['expired']) && !empty($_POST['expired'])) {
        list($vtd, $vtm, $vty) = explode("/", $_POST['expired']);
        $expired = $vty.'-'.$vtm.'-'.$vtd;
    }

    $qualifications->fk_created_by = $user->id;
    $qualifications->num 		= $num;
	$qualifications->type 	  	= $type;
	$qualifications->delivered  = $delivered;
	$qualifications->expired	= $expired;
	$qualifications->subject	= $subject;
	$qualifications->definitive = $defs;
	$qualifications->provisional= $provs;

	$getQualifId = $qualifications->create();

    // If no SQL error we redirect to the request card
    if ($getQualifId > 0) {
    	header('Location: ./index.php?id='.$getQualifId);
        exit;
    } else {
        // Otherwise we display the request form with the SQL error message
        header('Location: ./card.php?action=request&error=SQL_Create&msg='.$qualifications->error);
        exit;
    }
}

if ($_POST['action'] == 'update' && $_POST['qc_id'] > 0 && $_SERVER['REQUEST_METHOD'] === 'POST') {
	$qc_id = (int) $_POST['qc_id'];

	// If no right to create a request
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='add';
    } else {
	    $defs  = array();
	    $provs = array();
	    // definitive
	    if (count($_POST['def_sector'])) {
	    	foreach ($_POST['def_sector'] as $key => $val) {
	    		$qualification 	= $_POST['def_qualif'][$key];
	    		$class 			= $_POST['def_class'][$key];

	    		if (!$val && !$qualification && !$class)
	    			continue;

	    		$defs['sector'][] 		 = $val;
	    		$defs['qualification'][] = $qualification;
	    		$defs['class'][] 		 = $class;
	    	}
	    }

	    // provisoire
	    if (count($_POST['prov_sector'])) {
	    	foreach ($_POST['prov_sector'] as $key => $val) {
	    		$qualification 	= $_POST['prov_qualif'][$key];
	    		$class 			= $_POST['prov_class'][$key];

	    		if (!$val && !$qualification && !$class)
	    			continue;

	    		$provs['sector'][] 		  = $val;
	    		$provs['qualification'][] = $qualification;
	    		$provs['class'][] 		  = $class;
	    	}
	    }

	    $num 	 = trim(GETPOST('num'));
	    $type    = GETPOST('type');
	    $subject = trim(GETPOST('subject'));
	    $budget  = trim(GETPOST('budget_'));

	    // Dates
	    $delivered = null;
	    $expired   = null;
	    if (isset($_POST['delivered']) && !empty($_POST['delivered'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['delivered']);
	        $delivered = $ety.'-'.$etm.'-'.$etd;
	    }
	    
	    if (isset($_POST['expired']) && !empty($_POST['expired'])) {
	        list($vtd, $vtm, $vty) = explode("/", $_POST['expired']);
	        $expired = $vty.'-'.$vtm.'-'.$vtd;
	    }

	    $data = array(
	    	'num'		  => $num,
			'type' 	  	  => $type,
			'delivered'   => $delivered,
			'expired'	  => $expired,
			'subject'	  => $subject,
			'definitive'  => serialize($defs),
			'provisional' => serialize($provs)
		);

		$getQualif = $qualifications->update($qc_id, $data);

	    // If no SQL error we redirect to the request card
	    if ($getQualif > 0) {
	    	header('Location: ./index.php?id='.$qc_id);
	        die();
	    } else {
	        // Otherwise we display the request form with the SQL error message
	        header('Location: ./card.php?action=request&error=SQL_Create&msg='.$qualifications->error);
	        die();
	    }
	}
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' && $user->rights->marches->delete) {
	$error = 0;

	$db->begin();

	$qualification  = new Qualifications($db);
	$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $qualification->id = (int) $id;
		$qualification->delete();
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
		header('Location: ./index.php?leftmenu=marches');
		exit;
	} else {
		$db->rollback();
        header('Location: ./index.php?leftmenu=marches');
        exit;
	}
}

$form        	= new Form($db);
$qualification  = new Qualifications($db);
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/marches/js/jquery/timepicker/timepicker-fr.js", "/marches/js/marches.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('EntrepriseQC'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {
        // Formulaire de QC
        $title = $langs->trans("AddQC");
		print_fiche_titre($title,'','');
		
		dol_fiche_head('', 'tabgmbc', $langs->trans('AddQC'), 0, '');

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';
        // Num
        print '<tr><td class="fieldrequired">'.$langs->trans("RefAO").'</td><td>';
        print '<input type="text" value="" name="num" required="required" />';
        print '</td></tr>';
        // Qualification/Classification
        print '<tr><td>'.$langs->trans("Type").'</td><td>';
        print $form->selectarray('type', $qualification->getTypes(), (GETPOST('type') ? GETPOST('type') : ''), 1, 0, 0, '');
        print '</td></tr>';
        // Subject
        print '<tr><td>'.$langs->trans("Subject").'</td><td>';
        print '<textarea name="subject" row="10" cols="60"></textarea>';
        print '</td></tr>';
        // delivered start
        print '<tr><td>'.$langs->trans("DileveredDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="delivered" readonly="readonly" /> ';
        print '</td></tr>';
        // expired end
        print '<tr><td class="">'.$langs->trans("ExpiredDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="expired" readonly="readonly" /> ';
        print '</td></tr>';

        print '</tbody>';
        print '</table><br /><br />';

        // Definitive
		print_fiche_titre('Définitif','', 'title_accountancy.png');
        print '<table id="to_parent_wrapper" class="border" width="100%">';
		print "<tr>";
			print '<td align="center">'.$langs->trans("Sector").'</td>';
			print '<td align="center">'.$langs->trans("Qualification").'</td>';
			print '<td align="center">'.$langs->trans("Class").'</td>';
			print '<td align="center">&nbsp;</td>';
		print '</tr>';
		print '<tr class="def_qualif_wrapper_0 counted_lines_def" data-trans-order="0">';
			print '<td align="center"><input type="text" class="def_sector center" name="def_sector[]" size="50" /></td>';
			print '<td align="center"><input type="text" class="def_qualif center" name="def_qualif[]" size="50" /></td>';
			print '<td align="center"><input type="text" class="def_class center" name="def_class[]" size="50" /></td>';
			print '<td align="center"><a data-id="" class="delete_def_img" style="display:none;" href="javascript:void(0);"><img src="'.DOL_URL_ROOT.'/theme/'. $conf->theme .'/img/delete.png" /></a></td>';
		print '</tr>';
        print '</table>';

		print '<div style="float: left; margin-top: 5px;">';
		print '<a id="addMoreDefQulif" href="javascript:void(0);" class="butAction">'.$langs->trans('AddNewLine').'</a>';
		print '</div><br /><br /><br />';

		// provisional
		print_fiche_titre('Provisoire','', 'title_accountancy.png');
        print '<table id="to_parent_wrapper_prov" class="border" width="100%">';
		print "<tr>";
			print '<td align="center">'.$langs->trans("Sector").'</td>';
			print '<td align="center">'.$langs->trans("Qualification").'</td>';
			print '<td align="center">'.$langs->trans("Class").'</td>';
			print '<td align="center">&nbsp;</td>';
		print '</tr>';
		print '<tr class="prov_qualif_wrapper_0 counted_lines" data-trans-order="0">';
			print '<td align="center"><input type="text" class="prov_sector center" name="prov_sector[]" size="50" /></td>';
			print '<td align="center"><input type="text" class="prov_qualif center" name="prov_qualif[]" size="50" /></td>';
			print '<td align="center"><input type="text" class="prov_class center" name="prov_class[]" size="50" /></td>';
			print '<td align="center"><a data-id="" class="delete_prov_img" style="display:none;" href="javascript:void(0);"><img src="'.DOL_URL_ROOT.'/theme/'. $conf->theme .'/img/delete.png" /></a></td>';
		print '</tr>';
        print '</table>';

		print '<div style="float: left; margin-top: 5px;">';
		print '<a id="addMoreProvQulif" href="javascript:void(0);" class="butAction">'.$langs->trans('AddNewLine').'</a>';
		print '</div>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateQC") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    }
} else {
	if ($id > 0) {
		$qualifications->fetch($id);

		$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

		if ($canedit) {
            if ($action == 'delete') {
                if($user->rights->marches->delete) {
                    print $form->formconfirm("./card.php?id=".$id, $langs->trans("TitleDeleteQC"),$langs->trans("ConfirmDeleteQC"),"confirm_delete", '', 0, 1);
                }
            }

			if ($action == 'edit' || $action == 'delete') {
					$title = $langs->trans("EditQC");
				print_fiche_titre($title,'','');
				dol_fiche_head('', 'tabgmbc', $langs->trans('AddQC'), 0, '');
	    		$delivered 	= null !== $qualifications->delivered ? dol_print_date($qualifications->delivered,'day') : '';
	    		$expired 	= null !== $qualifications->expired ? dol_print_date($qualifications->expired,'day') : '';

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="qc_id" value="'. $id .'" />'."\n";

		        print '<table class="border" width="100%">';
		        print '<tbody>';
		        // Num
		        print '<tr><td class="fieldrequired">'.$langs->trans("RefAO").'</td><td>';
		        print '<input type="text" value="'. $qualifications->num .'" name="num" />';
		        print '</td></tr>';
		        // Qualification/Classification
		        print '<tr><td>'.$langs->trans("Type").'</td><td>';
		        print $form->selectarray('type', $qualification->getTypes(), (GETPOST('type') ? GETPOST('type') : $qualifications->type), 1, 0, 0, '');
		        print '</td></tr>';
		        // Subject
		        print '<tr><td>'.$langs->trans("Subject").'</td><td>';
		        print '<textarea name="subject" row="10" cols="60">'. nl2br($qualifications->subject) .'</textarea>';
		        print '</td></tr>';
		        // delivered start
		        print '<tr><td>'.$langs->trans("DileveredDate").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  name="delivered" readonly="readonly" value="'. $delivered .'" /> ';
		        print '</td></tr>';
		        // expired end
		        print '<tr><td class="">'.$langs->trans("ExpiredDate").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  name="expired" readonly="readonly" value="'. $expired .'" /> ';
		        print '</td></tr>';

		        print '</tbody>';
		        print '</table><br /><br />';

		        // Definitive
				print_fiche_titre('Définitif','', 'title_accountancy.png');
		        print '<table id="to_parent_wrapper" class="border" width="100%">';
				print "<tr>";
					print '<td align="center">'.$langs->trans("Sector").'</td>';
					print '<td align="center">'.$langs->trans("Qualification").'</td>';
					print '<td align="center">'.$langs->trans("Class").'</td>';
					print '<td align="center">&nbsp;</td>';
				print '</tr>';

				if (is_array($qualifications->definitive) and count($qualifications->definitive)) {
					foreach ($qualifications->definitive['sector'] as $key => $val) {
						if (!$val)
							continue;

						$qualif = $qualifications->definitive['qualification'][$key];
						$class  = $qualifications->definitive['class'][$key];
						$display = $key == 0 ? 'display:none;' : '';

						print '<tr class="def_qualif_wrapper_'. $key .' counted_lines_def" data-trans-order="'. $key .'">';
							print '<td align="center"><input type="text" class="def_sector center" name="def_sector[]" size="50" value="'. $val .'" /></td>';
							print '<td align="center"><input type="text" class="def_qualif center" name="def_qualif[]" size="50" value="'. $qualif .'" /></td>';
							print '<td align="center"><input type="text" class="def_class center" name="def_class[]" size="50" value="'. $class .'" /></td>';
							print '<td align="center"><a data-id="" style="'. $display .'" class="delete_def_img" href="javascript:void(0);"><img src="'.DOL_URL_ROOT.'/theme/'. $conf->theme .'/img/delete.png" /></a></td>';
						print '</tr>';
					}
				} else {
					print '<tr class="def_qualif_wrapper_0 counted_lines_def" data-trans-order="0">';
						print '<td align="center"><input type="text" class="def_sector center" name="def_sector[]" size="50" /></td>';
						print '<td align="center"><input type="text" class="def_qualif center" name="def_qualif[]" size="50" /></td>';
						print '<td align="center"><input type="text" class="def_class center" name="def_class[]" size="50" /></td>';
						print '<td align="center"><a data-id="" class="delete_def_img" style="display:none;" href="javascript:void(0);"><img src="'.DOL_URL_ROOT.'/theme/'. $conf->theme .'/img/delete.png" /></a></td>';
					print '</tr>';
				}
			    
			    print '</table>';

				print '<div style="float: left; margin-top: 5px;">';
				print '<a id="addMoreDefQulif" href="javascript:void(0);" class="butAction">'.$langs->trans('AddNewLine').'</a>';
				print '</div><br /><br /><br />';

				// provisional
				print_fiche_titre('Provisoire','', 'title_accountancy.png');
		        // print '<h2></h2>';
		        print '<table id="to_parent_wrapper_prov" class="border" width="100%">';
				print "<tr>";
					print '<td align="center">'.$langs->trans("Sector").'</td>';
					print '<td align="center">'.$langs->trans("Qualification").'</td>';
					print '<td align="center">'.$langs->trans("Class").'</td>';
					print '<td align="center">&nbsp;</td>';
				print '</tr>';

				if (is_array($qualifications->provisional) and count($qualifications->provisional)) {
					foreach ($qualifications->provisional['sector'] as $key => $val) {
						if (!$val)
							continue;

						$qualif = $qualifications->provisional['qualification'][$key];
						$class  = $qualifications->provisional['class'][$key];
						$display = $key == 0 ? 'display:none;' : '';

						print '<tr class="prov_qualif_wrapper_'. $key .' counted_lines" data-trans-order="'. $key .'">';
							print '<td align="center"><input type="text" class="prov_sector center" name="prov_sector[]" size="50" value="'. $val .'" /></td>';
							print '<td align="center"><input type="text" class="prov_qualif center" name="prov_qualif[]" size="50" value="'. $qualif .'" /></td>';
							print '<td align="center"><input type="text" class="prov_class center" name="prov_class[]" size="50" value="'. $class .'" /></td>';
							print '<td align="center"><a data-id="" style="'. $display .'" class="delete_prov_img" href="javascript:void(0);"><img src="'.DOL_URL_ROOT.'/theme/'. $conf->theme .'/img/delete.png" /></a></td>';
						print '</tr>';
					}
				} else {
					print '<tr class="prov_qualif_wrapper_0 counted_lines" data-trans-order="0">';
						print '<td align="center"><input type="text" class="prov_sector center" name="prov_sector[]" size="50" /></td>';
						print '<td align="center"><input type="text" class="prov_qualif center" name="prov_qualif[]" size="50" /></td>';
						print '<td align="center"><input type="text" class="prov_class center" name="prov_class[]" size="50" /></td>';
						print '<td align="center"><a data-id="" class="delete_prov_img" style="display:none;" href="javascript:void(0);"><img src="'.DOL_URL_ROOT.'/theme/'. $conf->theme .'/img/delete.png" /></a></td>';
					print '</tr>';
				}
		        print '</table>';

				print '<div style="float: left; margin-top: 5px;">';
				print '<a id="addMoreProvQulif" href="javascript:void(0);" class="butAction">'.$langs->trans('AddNewLine').'</a>';
				print '</div>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    
                    // If draft
                    if ($user->rights->marches->delete)	{
                    	print '<a href="./card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>