<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/settings/rental_equipment/class/RentalEquipment.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/machine_categories/class/MachineCategories.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/machine_mark/class/MachineMark.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/counter_type/class/CounterType.class.php';
$rental_equipement = new RentalEquipment($db);
$var = false;
$form=new Form($db);
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$action  = GETPOST('action', 'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "";
$search_ref      	= GETPOST('search_ref');
$search_tenant     	= GETPOST('search_tenant');
$search_categ    	= GETPOST('search_categ');
$search_compteur   	= GETPOST('search_compteur');
$search_marque     	= GETPOST('search_marque');
$search_driver     	= GETPOST('search_driver');
$search_num    		= GETPOST('search_num');
$search_type      	= GETPOST('search_type');
$search_rate      	= GETPOST('search_rate');
$search_stat     	= GETPOST('search_stat');

$id 	  = GETPOST('id','int');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_ref      			= "";
$search_tenant      			= "";
$search_categ    			    = "";
$search_compteur      			= "";
$search_marque      			= "";
$search_driver      			= "";
$search_num    			        = "";
$search_type      		    	= "";
$search_rate      		    	= "";
}
$filter='';
$filter .= (!empty($search_ref) && $search_ref != -1) ? " and  rowid = ". $db->escape((int)$search_ref) ."\n" : "";
$filter .= (!empty($search_tenant) && $search_tenant != -1) ? " and  fk_tenant = ". $db->escape((int)$search_tenant) ."\n" : "";
$filter .= (!empty($search_categ) && $search_categ != -1) ? " and  fk_machine_cat = ". $db->escape((int)$search_categ) ."\n" : "";
$filter .= (!empty($search_marque) && $search_marque != -1) ? " and fk_machine_mark = ". $db->escape((int)$search_marque) ."\n" : "";
$filter .= (!empty($search_compteur) && $search_compteur != -1) ? " and  fk_counter_type = ". $db->escape((int)$search_compteur) ."\n" : "";
$filter .= (!empty($search_driver) && $search_driver != -1) ? " and  fk_driver = ". $db->escape((int)$search_driver) ."\n" : "";
$filter .= (!empty($search_num) && $search_num != -1) ? " and  register_num = '". $db->escape($search_num) ."'\n" : "";
$filter .= (!empty($search_type) && $search_type != -1) ? " and  type = '". $db->escape($search_type) ."'\n" : "";
$filter .= (!empty($search_rate) && $search_rate != -1) ? " and  rate = ". $db->escape((float)$search_rate) ." \n" : "";
$getrental_equipement=$rental_equipement->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter, $id);
if (!empty($getrental_equipement) && $action == "xsl" ) {
$filename="liste_location_materials.xls";
      require_once DOL_DOCUMENT_ROOT.'/btp/settings/rental_equipment/tpl/rental_equipment_exl.php';
 die();
 
}
if ($id > 0) {
	llxHeader('', $langs->trans('rental'));
  	print_fiche_titre($langs->trans('detai_rental_equip'));
	dol_fiche_head('', 'events', $langs->trans("rental"), 0, '');
	$rental_equipement->fetch($id);
	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Refe").'</td>';
	print '<td colspan="2">'. $rental_equipement->rowid .'</td></tr>';
	    //locataire
       	$user_ten = new User($db);
        $user_ten->fetch($rental_equipement->fk_tenant);      
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("tenant").'</td>';
	  $nom=$user_ten->lastname.'  '.$user_ten->firstname;
	print '<td colspan="2">'. $user_ten->getNomUrl(1,$rental_equipement->fk_tenant,$nom).'</td></tr>';
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine_categorie").'</td>';
	 $categ_machine   = new MachineCategories($db);
       $categ_machine->fetch($rental_equipement->fk_machine_cat);
	print '<td colspan="2">'. $categ_machine->getNomUrl(1,$rental_equipement->fk_machine_cat,$categ_machine->name) .'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("counter_type").'</td>';
       $type_compteur   = new CounterType($db);
       $type_compteur->fetch($rental_equipement->fk_counter_type);
	print '<td colspan="2">'. $type_compteur->getNomUrl(1,$rental_equipement->fk_counter_type,$type_compteur->name) .'</td></tr>';
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine_mark").'</td>';
		$mark_machine   = new MachineMark($db);
       $mark_machine->fetch($rental_equipement->fk_machine_mark);
	print '<td colspan="2">'. $mark_machine->getNomUrl(1,$rental_equipement->fk_machine_mark,$mark_machine->name)  .'</td></tr>';
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("driver").'</td>';
	$driver = new User($db);
    $driver->fetch($rental_equipement->fk_driver); 
     $name=$driver->lastname.'  '.$driver->firstname; 
	print '<td colspan="2">'.$driver->getNomUrl(1,$rental_equipement->fk_driver,$name) .'</td></tr>';
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("regigster_num").'</td>';
	print '<td colspan="2">'. $rental_equipement->register_num .'</td></tr>';
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("type").'</td>';
	print '<td colspan="2">'. $rental_equipement->type .'</td></tr>';
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("rate").'</td>';
	print '<td colspan="2">'. $rental_equipement->rate .'</td></tr>';
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '<a href="./card.php?action=delete&id='. $id .'" class="butAction">'.$langs->trans('Delete').'</a>';
	print '</div>';
}
else {
llxHeader('', $langs->trans('listerentalequip'));
  print_fiche_titre($langs->trans('listerentalequip'));
print '<div style="float: right; margin-bottom: 4px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addlocation').'</a>';
		print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_ref" value="'. $search_ref .'" type="hidden" />';
print '<input name="search_tenant" value="'. $search_tenant .'" type="hidden" />';
print '<input name="search_categ" value="'. $search_categ .'" type="hidden" />';
print '<input name="search_compteur" value="'. $search_compteur .'" type="hidden" />';
print '<input name="search_marque" value="'. $search_marque .'" type="hidden" />';
print '<input name="search_driver" value="'. $search_driver .'" type="hidden" />';
print '<input name="search_rate" value="'. $search_rate .'" type="hidden" />';
print '<input name="search_num" value="'. $search_num .'" type="hidden" />';
print '<input name="search_type" value="'. $search_type .'" type="hidden" />';
print '<input name="search_stat" value="'. $search_stat .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';   
	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Refe"),$_SERVER["PHP_SELF"], "rowid", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("tenant"),$_SERVER["PHP_SELF"],"name", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("machine_categorie"), $_SERVER["PHP_SELF"], 'fk_machine_cat', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("counter_type"),$_SERVER["PHP_SELF"], 'fk_counter_type', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("machine_mark"),$_SERVER["PHP_SELF"],'fk_machine_mark','','',$sortfield,$sortorder,'maxwidthsearch ');
	print_liste_field_titre($langs->trans("driver"),$_SERVER["PHP_SELF"], 'fk_tenant', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("regigster_num"),$_SERVER["PHP_SELF"],"registre_num",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print_liste_field_titre($langs->trans("type"),$_SERVER["PHP_SELF"],"",'type','','',$sortfield,$sortorder,'maxwidthsearch ');
	print_liste_field_titre($langs->trans("rate"),$_SERVER["PHP_SELF"],'rate','','',$sortfield,$sortorder,'maxwidthsearch ');
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";
	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';
	print '<td class="liste_titre" align="left" width="50">';    
 	print $form->select_dolusers($search_tenant,"search_tenant",1); 
	print '</td>';print '<td class="liste_titre" align="left" width="50">';  
	print '<select name="search_categ"      id="nomer"/>';
        $catege  = new MachineCategories($db);
        $catege->fetchAll(); 
        print '<option></option>';
        if (count($catege->rows)) {
      
        foreach($catege->rows as $line) {
        	$a='';
        	if ($search_categ) {
  	 if ($line->rowid==$search_categ){ $a=' selected="selected"';

  }}
       print '<option value="'.$line->rowid.'"'.$a.'>'.$line->name.'</option>';
      $a='';
        }
    }
		print '</select>';
		print '</td>';print '<td class="liste_titre" align="left" width="50">';
		print '<select name="search_compteur"      id="nomer"/>';
		$pia='';
		$comp   = new CounterType($db);
		$comp->fetchAll();  print '<option></option>';
		if (count($comp->rows)) {

		foreach($comp->rows as $line) {
		if ($search_compteur) {
		if ($line->rowid==$search_compteur){ $pia=' selected="selected"';

  }}
       print '<option  value="'.$line->rowid.'"'.$pia.'>'.$line->name.'</option>';
      	$pia='';
        }
    }
        print '</select>';
        print '</td>';
        print '<td class="liste_titre" align="left" width="50">';
        print '<select name="search_marque"      id="nomer"/>';
         	$poa='';
        $mark  = new MachineMark($db);
        $mark->fetchAll();  print '<option></option>';
        if (count($mark->rows)) {
      
        foreach($mark->rows as $line) {
        	if ($search_marque) {
  	 if ($line->rowid==$search_marque){ $poa=' selected="selected"';

  }}
       print '<option  value="'.$line->rowid.'"'.$poa.'>'.$line->name.'</option>';
      $poa='';
        }
    }
        print '</select>';
        print '</td>';
        print '<td class="liste_titre" align="left" width="50">';
        print $form->select_dolusers($search_driver,"search_driver",1); 
        print '</td>';  
        print '<td class="liste_titre" align="left" width="50">';
        print '<input type=text name="search_num" value="'.$search_num.'" >';
        print '</td>'; 
        print '<td class="liste_titre" align="left" width="50">';
        print '<input type=text name="search_type" value="'.$search_type.'">';
        print '</td>'; 
        print '<td class="liste_titre" align="left" width="50">';
        print '<input type=text name="search_rate" value="'.$search_rate.'">';
        print '</td>';
	    // ACTION
	    print '<td align="right">';
	    print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
		print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
		print '</td>';
		print "</tr>\n";
	// Lines
	if (count($rental_equipement->rows)) {
		//$createdBy = new User($db);
		foreach($rental_equipement->rows as $line) {
			$var = !$var;
			$rowid 				= $line->rowid;
			$fk_tenant 			= $line->fk_tenant;
			$fk_machine_cat		= $line->fk_machine_cat;
			$fk_machine_mark	= $line->fk_machine_mark;
			$fk_counter_type	= $line->fk_counter_type;
			$fk_driver	   		= $line->fk_driver;
			$register_num  		= $line->register_num;
			$type		   		= $line->type;
			$rate     	  		= $line->rate;
			$statut       		= $line->statut;
			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $rental_equipement->getNomUrl(1,$line->rowid, $rowid);
			print '</td>';
				 $user_tenant = new User($db);
             $user_tenant->fetch($fk_tenant);  
             $nom=$user_tenant->lastname.'  '. $user_tenant->firstname;
      		print '<td align="center">'.$user_tenant->getNomUrl(1,$fk_tenant,$nom)  .'</td>';
			  $categ_machine   = new MachineCategories($db);
             $categ_machine->fetch($fk_machine_cat);
	        print '<td align="center">'.$categ_machine->getNomUrl(1,$fk_machine_cat,$categ_machine->name).'</td>';
	        $type_compteur   = new CounterType($db);
            $type_compteur->fetch($fk_counter_type);
	        print '<td align="center">'.$type_compteur->getNomUrl(1,$fk_counter_type,$type_compteur->name).'</td>';
	       	$mark_machine   = new MachineMark($db);
            $mark_machine->fetch($fk_machine_mark);
		   	print '<td align="center">'. $mark_machine->getNomUrl(1,$fk_machine_mark,$mark_machine->name) .'</td>';
			 $use_tenan = new User($db);
             $use_tenan->fetch($fk_driver);  
             $name= $use_tenan->lastname.'  '. $use_tenan->firstname;
      		print '<td align="center">'.$use_tenan->getNomUrl(1,$fk_driver,$name) .'</td>';
			print '<td align="center">'. $register_num .'</td>';
			print '<td align="center">'. $type .'</td>';
			print '<td align="center">'. $rate .'</td>';
			print '<td><div style="float: right; margin-top: 8px;">';
			print '</div></td>';
			print '</tr>'."\n";
		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}
	print '</table>';
	print '</form>';
	
}
llxFooter();

$db->close();


?>
