<?php
require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';

class StakeHolder extends NXdb{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
    /**
	 * @var string Id to identify managed objects
	 */
	public $element = 'mc_stakeholder';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'mc_stakeholder';
	public $fk_createdby;
	public $rows = array();
	public $now;
    public $rowid;
    public $fk_user;
    public $fk_type;
    public $tel;
    public $fax;

		public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		return 1;
	}
public function create()
	{
 	dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->name		= $this->name ? $this->db->escape($this->name): null;
		$this->fk_user  = $this->fk_user ? $this->db->escape($this->fk_user): null;
		$this->fk_type  = $this->fk_type ? $this->db->escape($this->fk_type): null;
		$this->tel	    = $this->tel ? $this->db->escape($this->tel): null;
		$this->fax      = $this->fax ? $this->db->escape($this->fax): null;
	// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (name,fk_user,fk_type,tel,fax,created_at,updated_at) VALUES (';
		$sql .= '"'.$this->name.'", '.$this->fk_user.','.$this->fk_type.',"'.$this->tel.'","'.$this->fax.'","'.$this->now.'","'.$this->now.'")';
		$this->db->begin();
		$resql = $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error Evenement ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			
			return -1;
		} else {
			$this->db->commit();
	 return $this->getLasInsrtedId();
		}
	}
public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			 = $this->db->fetch_object($resql);
				$this->rowid 	 = $obj->rowid;
				$this->name		 = $obj->name;
				$this->fk_user	 = $obj->fk_user;
				$this->fk_type	 = $obj->fk_type;
				$this->tel		 = $obj->tel;
				$this->fax		 = $obj->fax;
			}
			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			echo 	$sql;
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/settings/stakeholders/index.php?id='. $id .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';
        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE  rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;
		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET ';
		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
		$sql  = substr($sql, 0, -1);
		$sql.=',updated_at="'.$this->now.'"';
		$sql .= ' WHERE  rowid = ' . $id;

		$this->db->begin();
		$resql = $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
  //search
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $id = '')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .$this->table_element;

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
		}
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->rowid 	= $obj->rowid;
				$line->name 	= $obj->name;
				$line->fk_type 	= $obj->fk_type;
				$line->fk_user 	= $obj->fk_user;
				$line->tel 		= $obj->tel;
				$line->fax 		= $obj->fax;
				$this->rows[] 	= $line;
}
		

			$this->db->free($resql);
			return $num;
		} else {
			echo 'erreur';

			die();
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}
	public function getStakeHoldersList()
	{
		$this->fetchAll();

		$stakeholers = array();

		if (count($this->rows))
			foreach ($this->rows as $key => $row) {
				$stakeholers[$row->rowid] = ucfirst($row->name);
			}
		return $stakeholers;
	}
}
