<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       tools/index.php
 * \ingroup    list
 * \brief      List of tools
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/settings/tools_type/class/ToolsType.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/tools/class/tools.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';

$form 		= new Form($db);
$tool 	  = new ToolsSettings($db);
$var = false;
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "";
$search_ref      			= GETPOST('search_ref');
$search_dsg      	= GETPOST('search_dsg');
$search_type      	= GETPOST('search_type');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref      			= "";
	$search_dsg      	= "";
	$search_type     		= "";

}
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$filter='';
$filter .= (!empty($search_ref) && $search_ref != -1) ? " and  rowid = ". $db->escape((int)$search_ref) ."\n" : "";
$filter .= (!empty($search_dsg) && $search_dsg != -1) ? " AND designation = '".$db->escape($search_dsg)."'\n" : "";
$filter .= (!empty($search_type) && $search_type != -1) ? " AND tool_type_id = ".$db->escape((int)$search_type)."\n" : "";
$gettools=$tool->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter, $id);
if (!empty($gettools) && $action == "xsl" ) {
$filename="liste_outils.xls";
      require_once DOL_DOCUMENT_ROOT.'/btp/settings/tools/tpl/tools_exl.php';
 die();
 
}
if ($id > 0) {
	llxHeader('', $langs->trans('tool'));
    print_fiche_titre($langs->trans('detai_tool'));
	dol_fiche_head('', 'tools', $langs->trans("tool"), 0, '');

	$tool->fetch($id);
	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Refe").'</td>';
	print '<td colspan="2">'. $tool->rowid .'</td></tr>';
	//Nom
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Designation").'</td>';
	print '<td colspan="2">'. $tool->designation .'</td></tr>';
	//Type
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Type").'</td>';
    $typetls   = new ToolsType($db);
    $typetls->fetch($tool->tool_type_id); 
	print '<td colspan="2">'.$typetls->getNomUrl(1, $tool->tool_type_id,$typetls->name).'</td></tr>';
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'" class="butAction">'.$langs->trans('Delete').'</a>';
	print '</div>';

if ($action == 'delete') {
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDeleteT"),$langs->trans("ConfirmDeleteT"),"confirm_delete", '', 0, 1);
              }
}
else {

 // Both test are required to be compatible with all browsers


llxHeader('', $langs->trans('list_tools'));
print_fiche_titre($langs->trans('list_tools'));




	
	$card="card.php";
print '<div style="float: right; margin-bottom: 4px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('ajoutetools').'</a>';
		print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_ref" value="'. $search_ref .'" type="hidden" />';
print '<input name="search_dsg" value="'. $search_dsg .'" type="hidden" />';
print '<input name="search_type" value="'. $search_type .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Refe"),$_SERVER["PHP_SELF"], "rowid", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Designation"),$_SERVER["PHP_SELF"],"name", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Type"), $_SERVER["PHP_SELF"], '', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"], '', '', '', 'align="center"', $sortfield, $sortorder);
	print "</tr>\n";
	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';
	// name
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_dsg" value="'.$search_dsg.'">';
	print '</td>';
	print '<td class="liste_titre" align="left" width="50">';    
        print '<select name="search_type"     id="nomer"/>';
      $pa='';
        $evt   = new ToolsType($db);
        $evt->fetchall();  print '<option></option>';
        if (count($evt->rows)) {
      
        foreach($evt->rows as $line) {
        	if ($search_type) {
  	 if ($line->rowid==$search_type){ $pa=' selected="selected"';

  }}
       print '<option  value="'.$line->rowid.'"'.$pa.'>'.$line->name.'</option>';
      $pa='';
        }
    }
   print '</select>';
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";
	// Lines
	if (count($tool->rows)) {
			foreach($tool->rows as $line) {
			$var = !$var;
			$rowid 				= $line->rowid;
			$dsg 		        = $line->designation;
			$type 		        = $line->tool_type_id;
			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $tool->getNomUrl(1,  $line->rowid, $rowid);
			print '</td>';
			// designation
			print '<td align="center">'. $dsg .'</td>';
			$typetools   = new ToolsType($db);
             $typetools->fetch($type); 
			print '<td align="center">'.$typetools->getNomUrl(1,$type,$typetools->name).'</td>';
			print '<td align="center"></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

}	
print '</table>';
	print '</form>';
llxFooter();

$db->close();


?>
