<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des outils
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/settings/type_avance/class/type_avance.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/type_avance/class/type_avance.class.php';
// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

$langs->load('btp');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$error 	= false;
if ($action == 'update' && $request_method === 'POST') {
    $type_avance_id = (int) GETPOST('type_avance_id', 'int');

    if (!$type_avance_id || $type_avance_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }
    $type_avance = new type_avance($db);
    $type_avance->fetch($type_avance_id);
    $canedit = true ; 
      $dsg  = trim(GETPOST('dsg'));
    if ($canedit) {
        $dsg  = trim(GETPOST('dsg'));
            
		// Update
	
        $data = array(
            'designation'             => $dsg,
            
        );
        if(empty($dsg)){
              header('Location: ./card.php?id='. $type_avance_id .'&action=edit&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
            exit;
        }
        $getMarcheID = $type_avance->update($type_avance_id, $data);
 
        if ($getMarcheID > 0) {
        header('Location: ./index.php?id='.$type_avance_id);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='. $type_avance_id .'&action=edit&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
            exit;
        }
    }
}
// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;
	$type_avance  = new type_avance($db);
	 $canedit = true;
		if ($canedit) {
        $type_avance->fetch($id);
		$type_avance->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		header('Location: index.php');
		exit;
	}
	else {
        header('Location: index.php?leftmenu=type_avance');
        exit;
	}
}

/*
 * View
 */

$form           = new Form($db);
$type_avance     = new type_avance($db);
///////////////////////////insertion d'un outil
if ($action == 'create' && $request_method === 'POST') {
    $type_avance = new type_avance($db);
    $dsg         = GETPOST('dsg');
        //var
        $type_avance->designation                = trim(GETPOST('dsg'));
        
        $type_avance->fk_createdby                = $user->id;
        if(empty($type_avance->designation)){
  header('Location: card.php?action=request&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
exit();
        }
           $getMarcheID = $type_avance->create();
        
 if ($getMarcheID > 0) {
        header('Location: index.php?id='.$getMarcheID);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: card.php?action=request&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
exit(); 
        }   
}
llxHeader(array(), $langs->trans('listevents'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
        // Formulaire d'outil
        print_fiche_titre($langs->trans('ajoutetype_avance'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<table class="border" width="100%">';
        print '<tbody>';
        // disignation
         print '<tr><td class="fieldrequired">'.$langs->trans("Designation").'</td><td class="fieldrequired">';
        print '<input type=text name="dsg" required="required">';
        print '</td></tr>';
 
        print '</tbody>';
        print '</table>';
        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("CreateAvance") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
}
else {
    print_fiche_titre($langs->trans('details_type_avance'));

    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage 
        if ($id > 0) {
            $type_avance->fetch($id);
            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }
           
                if ($action == 'edit') {
                    $edit = true;
                    $id=$_GET['id'];

                

                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" id="h" name="type_avance_id" value='.$id.' />'."\n";
                  

                    print '<table class="border" width="100%">';
                    print '<tbody>';

                    // Name
                    print '<tr><td class="fieldrequired">'.$langs->trans("Designation").'</td><td>';
                    print '<input name="dsg" required="required" type=text value="'.$type_avance->designation.'"</td></tr>';
                    
         print '</tbody>';
                    print '</table>';
                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';
                    // Boutons d'actions
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';

                    // If draft
                   print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }
    }

}
//////////////////////////////////////confirmation de suppression
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
    $error=0;
    $type_avance  = new type_avance($db);
     $canedit = true;
       if ($canedit) {
        $type_avance->fetch($id);
        $type_avance->delete();
    }
    else {
        $error = $langs->trans('ErrorCantDelete');
    }

    if (!$error) {
         header('Location: index.php');
        exit;
    }
    else {
        
        header('Location: index.php?leftmenu=type_avance');
        exit;
    }
}
// End of page
llxFooter();llxFooter();

$db->close();


?>
