<?php 
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 *   	\file       btp/interimbail/card.php
 *		\ingroup    card
 *		\brief      Gestion des concurrents
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/class/tender.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/tender/interimbail/class/interimbail.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';


// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$td 	 = GETPOST('td', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$td && $request_method !== 'POST')
	die('ID de l\'ppel d\'offre n\'existe pas!');

$error     	 = false;
$interimbail = new InterimBail($db);
$tender 	 = new Tender($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {

    // If no right to create a request
   /* if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='request';
    }*/

    $td 		= trim(GETPOST('td', 'int'));
    $amount		= (float)trim(GETPOST('amount'));
   	$date_bail 	= trim(GETPOST('date_bail'));

    if (!$td || !$amount || !$date_bail)
    	return;

   	$num 		 	 = trim(GETPOST('num'));
   	$observation 	 = trim(GETPOST('observation'));
   	$date_withdrawal = trim(GETPOST('date_withdrawal'));

    $interimbail->fk_createdby  = $user->id;
    $interimbail->fk_tender 	= $td;
    $interimbail->amount 	 	= $amount;
	$interimbail->date_bail 	= Tools::convertDateTo($date_bail, 'sql');
	$interimbail->num 			= $num;
	$interimbail->observation 	= $observation;
	$interimbail->date_withdrawal= Tools::convertDateTo($date_withdrawal, 'sql');

	$getInterimBail = $interimbail->create();

	if ($getInterimBail)
	    header('Location: ./index.php?td='.$td.'&id='.$getInterimBail);
	else
	    header('Location: ./index.php?td='.$td);
    die();
}

if ($_POST['action'] == 'update' && $_POST['id'] && $_POST['td'] && $request_method === 'POST') {
	// If no right to create a request
/*    if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='add';
    } else {*/
	    $td 		= trim(GETPOST('td', 'int'));
	    $id  		= trim(GETPOST('id', 'int'));
	    $amount  	= trim(GETPOST('amount'));
	  	$date_bail  = trim(GETPOST('date_bail'));

	   	if (!$td || !$amount || !$date_bail)
    		return;

    	$num 		 	 = trim(GETPOST('num'));
	   	$observation 	 = trim(GETPOST('observation'));
	   	$date_withdrawal = trim(GETPOST('date_withdrawal'));

	    $data = array(
		    'amount' 		=> $amount,
			'date_bail' 	=> Tools::convertDateTo($date_bail, 'sql'),
			'date_withdrawal' => Tools::convertDateTo($date_withdrawal, 'sql'),
			'num' 			=> $num,
			'observation' 	=> $observation,
		);

		$interimbail->update($id, $td, $data);

    	header('Location: ./index.php?td='.$td.'&id='.$id);
        die();
	// }
}
/*
if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' && $user->rights->btp->delete) {
	$error = 0;
	$td = GETPOST('td', 'int');
	$id = GETPOST('id', 'int');
	
	if (!$td || !$id)
		return;

	$db->begin();

	$canedit = ($user->rights->btp->write_all || $user->rights->btp->delete);

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $interimbail->id = (int) $id;
        $interimbail->fk_tender = (int) $td;
		$interimbail->delete();
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
		header('Location: ./index.php?leftmenu=btp&td='.$td);
		exit;
	} else {
		$db->rollback();
        header('Location: ./index.php?leftmenu=btp&td='.$td);
        exit;
	}
}*/

$form 	 = new Form($db);
$morejs  = array("/btp/js/btp.js");
$morecss = array();

llxHeader(array(), $langs->trans('InterimBail'),'','','','',$morejs,$morecss,0,0);

if (empty($td) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[] = $langs->trans('CantCreatemarket');
    } else {*/
        // Formulaire de concurrents
		$tender->fetch($td);
		$head = tender_prepare_head($tender);
		dol_fiche_head($head, 'interimbail', $langs->trans('AddInterimBail'), 0, '');

		echo $tender->getTenderHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="td" value="'. $td .'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("NumBon").'</td><td>';
        print '<input type="text" class="" value="" name="num" required /></td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("ProvAmount").' TTC</td><td>';
        print '<input type="text" class="amount" value="" name="amount" required="required" /> '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
        
        print '<tr><td class="fieldrequired">'.$langs->trans("DateBail").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="date_bail" required="required" /></td></tr>';

        print '<tr><td class="">'.$langs->trans("DateWithdrawal").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="date_withdrawal" /></td></tr>';

        print '<tr><td valign="top">'.$langs->trans("Observation").'</td><td>';
        print '<textarea name="observation" rows="10" cols="60"></textarea></td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateInterimBail") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    // }
} else {
	if ($id > 0 && $td > 0) {
		$interimbail->fetch($id, $td);
		$tender->fetch($td);
		$head  = tender_prepare_head($tender);
		$canedit = true; /*($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
            if ($action == 'delete') {
                // if($user->rights->btp->delete) {
                    print $form->formconfirm("./card.php?td=".$td."&id=".$id, $langs->trans("DeleteInterim"),$langs->trans("ConfirmDeleteInterim"),"confirm_delete", '', 0, 1);
                // }
            }

			if ($action == 'edit' || $action == 'delete') {
				dol_fiche_head($head, 'interimbail', $langs->trans('InterimBail'), 0, '');

				echo $tender->getTenderHeader();

		        print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'" class="sub_form_prt">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="td" value="'. $td .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$num 		= $interimbail->num ? $interimbail->num : '';
				$observation= $interimbail->observation ? nl2br($interimbail->observation) : '';
				$amount 	= $interimbail->amount ? $interimbail->amount : '';
				$date_bail	= $interimbail->date_bail ? dol_print_date($interimbail->date_bail, 'day') : '';
				$date_withdrawal= $interimbail->date_withdrawal ? dol_print_date($interimbail->date_withdrawal, 'day') : '';

		        print '<table class="border" width="100%" data-row-id="0">';
		        print '<tbody>';

		        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("NumBon").'</td><td>';
		        print '<input type="text" class="" value="'. $num .'" name="num" required="required" /></td></tr>';
		        print '<tr><td class="fieldrequired">'.$langs->trans("ProvAmount").' TTC</td><td>';
		        print '<input type="text" class="amount" value="'. $amount .'" name="amount" required="required" /> '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
		        
		        print '<tr><td class="fieldrequired">'.$langs->trans("DateBail").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $date_bail .'" name="date_bail" required="required" /></td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("DateWithdrawal").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $date_withdrawal .'" name="date_withdrawal"  /></td></tr>';

		        print '<tr><td valign="top">'.$langs->trans("Observation").'</td><td>';
        		print '<textarea name="observation" rows="10" cols="60">'. $observation .'</textarea></td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction '. $addMoreBtns .'">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                print '</div>';

		        print '</form>';
			}
        }
	}
}



llxFooter();

$db->close();

?>