<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/tresorie/advance_supplier/class/advance_supplier.class.php';
include_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';



// Get parameters

$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$advance_supplier = new advance_supplier($db);

    if (!$error) {
        if (isset($_POST['date_start_']) && !empty($_POST['date_start_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['date_start_']);
            $advance_supplier->transaction_date         = $ety.'-'.$etm.'-'.$etd ;
        }
        if (isset($_POST['date_end_']) && !empty($_POST['date_end_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['date_end_']);
            $advance_supplier->due_date         = $ety.'-'.$etm.'-'.$etd ;
        }
          $advance_supplier->amount            = trim(GETPOST('amount_'));
          $advance_supplier->payment_id            = trim(GETPOST('payment_id_'));
          $advance_supplier->check_num     = trim(GETPOST('check_num_'));
          $advance_supplier->supplier_id     = trim(GETPOST('supplier_id_'));
          $advance_supplier->bank_id  = trim(GETPOST('bank_id_'));
          $advance_supplier->created_by     = $user->id;
            //if(!$advance_supplier->check_mat($advance_supplier->mat)){
                    $advance_supplierID = $advance_supplier->create();
            
                    // If no SQL error we redirect to the request card
                    if ($advance_supplierID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php');
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$advance_supplier->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$advance_supplier->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $advance_supplier_id = (int) GETPOST('advance_supplier_id', 'int');

    if (!$advance_supplier_id || $advance_supplier_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $advance_supplier = new advance_supplier($db);
    $advance_supplier->fetch($advance_supplier_id);

   // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $transaction_date = '';
        if (isset($_POST['date_start_']) && !empty($_POST['date_start_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['date_start_']);
            $transaction_date         = $ety.'-'.$etm.'-'.$etd ;
        }
        if (isset($_POST['date_end_']) && !empty($_POST['date_end_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['date_end_']);
            $due_date         = $ety.'-'.$etm.'-'.$etd ;
        }
        $data = array(
          'transaction_date'  =>$transaction_date,
          'amount'    =>trim(GETPOST('amount_')),
          'due_date'    =>$due_date,
          'payment_id'    =>trim(GETPOST('payment_id_')),
          'check_num' =>trim(GETPOST('check_num_')),
          'supplier_id' =>trim(GETPOST('supplier_id_')),
          'bank_id'  =>trim(GETPOST('bank_id_'))
        );

		$getadvance_supplierID = $advance_supplier->update($advance_supplier_id, $data);
        
                if ($getadvance_supplierID > 0) {
                    header('Location: ./index.php?id='.$advance_supplier_id);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $advance_supplier_id .'&action=edit&error=SQL_Create&msg='.$advance_supplier->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new advance_supplier($db);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php');
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$advance_supplier     = new advance_supplier($db);
$societe     = new societe($db);


$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('advance_supplier'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addadvance_supplier'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

       //date start
        print '<tr><td class="fieldrequired">'.$langs->trans("transaction_date").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="date_start_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //date start
        print '<tr><td class="fieldrequired">'.$langs->trans("due_date").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="date_end_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //amount
        print '<tr><td class="fieldrequired">'.$langs->trans("amount").'</td><td>';
        print '<input type="number" value="" step="0.01" min="0" name="amount_" required="required" />';
        print '</td></tr>';

        //supplier_id
        print '<tr><td class="fieldrequired">'.$langs->trans("supplier").'</td><td>';
        print  $form->select_thirdparty(null,"supplier_id_",'s.fournisseur=1');
        print '</td></tr>';

        //engin
        print '<tr><td class="fieldrequired">'.$langs->trans("payment").'</td><td>';
        print $form->select_types_paiements(null,'payment_id_');
        print '</td></tr>';

        
        //chantier 
        print '<tr><td>'.$langs->trans("check_num").'</td><td>'; 
        print '<input type="number" value="" name="check_num_" required="required" />';
        print '</td></tr>';

        //banque 
        print '<tr><td>'.$langs->trans("bank").'</td><td>'; 
        print $form->select_comptes(null,'bank_id_');
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createadvance_supplier") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    print_fiche_titre($langs->trans("advance_supplier"));
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $advance_supplier->fetch($id);

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndtransaction_dateP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'advance_suppliers', $langs->trans("advance_supplier"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="advance_supplier_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';


        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("transaction_date").'</td><td>';
        print '<input type="text" value="'.dol_print_date($advance_supplier->transaction_date,'day').'" class="datepicker" autocomplete="off"  name="date_start_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("due_date").'</td><td>';
        print '<input type="text" value="'.dol_print_date($advance_supplier->due_date,'day').'" class="datepicker" autocomplete="off"  name="date_end_" required="required" readonly="readonly" /> ';
        print '</td></tr>';


        //amount
        print '<tr><td class="fieldrequired">'.$langs->trans("amount").'</td><td>';
        print '<input type="number" step="0.01" min="0" value="'.$advance_supplier->amount.'" name="amount_" required="required" />';
        print '</td></tr>';

        //due_date
         print '<tr><td>'.$langs->trans("supplier").'</td><td>'; 
        print  $form->select_thirdparty($advance_supplier->supplier_id,"supplier_id_",'s.fournisseur=1');
        print '</td></tr>';

        //engin
        print '<tr><td class="fieldrequired">'.$langs->trans("payment").'</td><td>';
        print $form->select_types_paiements($advance_supplier->payment_id,'payment_id_');
        print '</td></tr>';

        //chantier 
        print '<tr><td>'.$langs->trans("check_num").'</td><td>'; 
        print '<input type="number" value="'.$advance_supplier->check_num.'" name="check_num_" required="required" />';
        print '</td></tr>';


       //procedure 
        print '<tr><td>'.$langs->trans("bank").'</td><td>'; 
        print $form->select_comptes($advance_supplier->bank_id,'bank_id_');
        print '</td></tr>';



                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->marches->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>