<?php
/* Copyright (C) 2016	Souieh Laghdaf	<laghdaf.souieh@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       /material/invoice_reception/index.php
 * \ingroup    list
 * \brief      List of location expensess
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/tresorie/invoice_reception/class/invoice_reception.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/material/receptions/class/receptions.class.php';
require_once DOL_DOCUMENT_ROOT . '/fourn/class/fournisseur.facture.class.php';



$form 		= new Form($db);
$invoice_reception     = new invoice_reception($db);
$receptions   = new receptions($db);
$facture = new FactureFournisseur($db);


$var = false;
$filter = '';
        
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$search_receptions    		= GETPOST('search_receptions');
$search_discount    		= GETPOST('search_discount');
$search_invoice    		= GETPOST('search_invoice');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_receptions    		= '';
$search_discount    		= '';
$search_invoice    		= '';
}
$filter .= (!empty($search_receptions) && $search_receptions != -1) ? " AND reception_id = ".$db->escape($search_receptions):"";
$filter .= (!empty($search_discount) && $search_discount != -1) ? " AND discount LIKE '".$db->escape($search_discount)."'":"";
$filter .= (!empty($search_invoice) && $search_invoice != -1) ? " AND invoice_id = ".$db->escape($search_invoice):"";


$getinvoice_receptions = $invoice_reception->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getinvoice_receptions == '-1') {
    print_fiche_titre($langs->trans('ListOfinvoice_reception'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$invoice_reception->error);
    exit();
}
if ($id > 0) {
	$invoice_reception->fetch($id);
	llxHeader('', $langs->trans('invoice_reception'));
	print_fiche_titre($langs->trans("invoice_reception"));


	print '<table class="border" width="100%">';
	// invoice
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("invoice").'</td>';
    $facture->fetch($invoice_reception->invoice_id);
    print '<td colspan="2">'. $facture->getNomUrl(1) .'</td></tr>';
    // receptions
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("receptions").'</td>';
    $receptions->fetch($invoice_reception->reception_id);
    print '<td colspan="2">'. $receptions->getNomUrl(1) .'</td></tr>';
	// remise
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("discount").'</td>';
	print '<td colspan="2">'. $invoice_reception->discount .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'" class="butAction">'.$langs->trans('Delete').'</a>';
	print '</div>';
	 if ($action == 'delete') {
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('invoice_receptions'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("ListOfinvoice_reception"));


	dol_fiche_head('', 'invoice_receptions', $langs->trans("Listinvoice_reception"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("ref"), $_SERVER["PHP_SELF"], 'rowid', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("invoice"), $_SERVER["PHP_SELF"], 'invoice_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("discount"), $_SERVER["PHP_SELF"], 'discount', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("receptions"), $_SERVER["PHP_SELF"], 'reception_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
    // ref
	print '<td class="liste_titre" colspan="1" align="center">';
	print '</td>';
	 // invoice
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->selectarray('search_invoice', $invoice_reception->getInvoices(),$search_invoice, 1, 0, 0);
    print '</td>';
	// discount
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number"  min="0" step="0.01"  name="search_discount" value="'.$search_discount.'">';
	print '</td>';
	// receptions
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_receptions', $receptions->getMats(), $search_receptions, 1, 0, 0);
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($invoice_reception->rows)) {
		//$createdBy = new User($db);
		foreach($invoice_reception->rows as $obj) {
			  $discount 				= $obj->discount ;
			  $facture->fetch($obj->invoice_id);
			  $receptions->fetch($obj->reception_id) ;
			  
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $invoice_reception->getNomUrl(1,  $obj->id, $obj->id);
			print '</td>';
			 
			print '<td align="center">'. $facture->getNomUrl(1)  .'</td>';
			print '<td align="center">'. $discount .'</td>';
			print '<td align="center">'. $receptions->getNomUrl(1) 	 .'</td>';
			print '<td align="center"></td>';
			
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addinvoice_reception').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>